/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.validation.hibernate;

import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.executable.ExecutableValidator;
import javax.validation.metadata.BeanDescriptor;
import org.wisdom.validation.hibernate.WrappedExecutableValidator;

public class WrappedValidator
implements Validator {
    private final Validator delegate;

    WrappedValidator(Validator delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Set<ConstraintViolation<T>> validate(T t, Class<?> ... classes) {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            Set set = this.delegate.validate(t, (Class[])classes);
            return set;
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public <T> Set<ConstraintViolation<T>> validateProperty(T t, String s, Class<?> ... classes) {
        return this.delegate.validateProperty(t, s, (Class[])classes);
    }

    public <T> Set<ConstraintViolation<T>> validateValue(Class<T> tClass, String s, Object o, Class<?> ... classes) {
        return this.delegate.validateValue(tClass, s, o, (Class[])classes);
    }

    public BeanDescriptor getConstraintsForClass(Class<?> aClass) {
        return this.delegate.getConstraintsForClass(aClass);
    }

    public <T> T unwrap(Class<T> tClass) {
        return (T)this.delegate.unwrap(tClass);
    }

    public ExecutableValidator forExecutables() {
        return new WrappedExecutableValidator(this.delegate.forExecutables());
    }
}

