/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.cluster.AbstractClusterOperation;
import com.hazelcast.cluster.ClusterServiceImpl;
import com.hazelcast.cluster.JoinOperation;
import com.hazelcast.cluster.MemberInfo;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class MemberInfoUpdateOperation
extends AbstractClusterOperation
implements JoinOperation {
    private Collection<MemberInfo> memberInfos;
    private long masterTime = Clock.currentTimeMillis();
    private boolean sendResponse = false;

    public MemberInfoUpdateOperation() {
        this.memberInfos = new ArrayList<MemberInfo>();
    }

    public MemberInfoUpdateOperation(Collection<MemberInfo> memberInfos, long masterTime, boolean sendResponse) {
        this.masterTime = masterTime;
        this.memberInfos = memberInfos;
        this.sendResponse = sendResponse;
    }

    @Override
    public void run() throws Exception {
        this.processMemberUpdate();
    }

    protected final void processMemberUpdate() {
        if (this.isValid()) {
            ClusterServiceImpl clusterService = (ClusterServiceImpl)this.getService();
            clusterService.setMasterTime(this.masterTime);
            clusterService.updateMembers(this.memberInfos);
        }
    }

    protected final boolean isValid() {
        ClusterServiceImpl clusterService = (ClusterServiceImpl)this.getService();
        Connection conn = this.getConnection();
        Address masterAddress = conn != null ? conn.getEndPoint() : null;
        return conn == null || masterAddress != null && masterAddress.equals(clusterService.getMasterAddress());
    }

    @Override
    public final boolean returnsResponse() {
        return this.sendResponse;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.masterTime = in.readLong();
        int size = in.readInt();
        this.memberInfos = new ArrayList<MemberInfo>(size);
        while (size-- > 0) {
            MemberInfo memberInfo = new MemberInfo();
            memberInfo.readData(in);
            this.memberInfos.add(memberInfo);
        }
        this.sendResponse = in.readBoolean();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeLong(this.masterTime);
        out.writeInt(this.memberInfos.size());
        for (MemberInfo memberInfo : this.memberInfos) {
            memberInfo.writeData(out);
        }
        out.writeBoolean(this.sendResponse);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MembersUpdateCall {\n");
        for (MemberInfo address : this.memberInfos) {
            sb.append(address).append('\n');
        }
        sb.append('}');
        return sb.toString();
    }
}

