/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection;

import com.hazelcast.collection.CollectionBackupAwareOperation;
import com.hazelcast.collection.CollectionClearBackupOperation;
import com.hazelcast.collection.CollectionDataSerializerHook;
import com.hazelcast.core.ItemEventType;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CollectionCompareAndRemoveOperation
extends CollectionBackupAwareOperation {
    private boolean retain;
    private Set<Data> valueSet;
    private Map<Long, Data> itemIdMap;

    public CollectionCompareAndRemoveOperation() {
    }

    public CollectionCompareAndRemoveOperation(String name, boolean retain, Set<Data> valueSet) {
        super(name);
        this.retain = retain;
        this.valueSet = valueSet;
    }

    @Override
    public boolean shouldBackup() {
        return !this.itemIdMap.isEmpty();
    }

    @Override
    public Operation getBackupOperation() {
        return new CollectionClearBackupOperation(this.name, this.itemIdMap.keySet());
    }

    @Override
    public int getId() {
        return CollectionDataSerializerHook.COLLECTION_COMPARE_AND_REMOVE;
    }

    @Override
    public void beforeRun() throws Exception {
    }

    @Override
    public void run() throws Exception {
        this.itemIdMap = this.getOrCreateContainer().compareAndRemove(this.retain, this.valueSet);
        this.response = !this.itemIdMap.isEmpty();
    }

    @Override
    public void afterRun() throws Exception {
        for (Data value : this.itemIdMap.values()) {
            this.publishEvent(ItemEventType.REMOVED, value);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeBoolean(this.retain);
        out.writeInt(this.valueSet.size());
        for (Data value : this.valueSet) {
            value.writeData(out);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.retain = in.readBoolean();
        int size = in.readInt();
        this.valueSet = new HashSet<Data>(size);
        for (int i = 0; i < size; ++i) {
            Data value = new Data();
            value.readData(in);
            this.valueSet.add(value);
        }
    }
}

