/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.countdownlatch.client;

import com.hazelcast.client.KeyBasedClientRequest;
import com.hazelcast.client.SecureRequest;
import com.hazelcast.concurrent.countdownlatch.client.CountDownLatchPortableHook;
import com.hazelcast.concurrent.countdownlatch.operations.CountDownOperation;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.CountDownLatchPermission;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;

public final class CountDownRequest
extends KeyBasedClientRequest
implements Portable,
SecureRequest {
    private String name;

    public CountDownRequest() {
    }

    public CountDownRequest(String name) {
        this.name = name;
    }

    @Override
    protected Object getKey() {
        return this.name;
    }

    @Override
    protected Operation prepareOperation() {
        return new CountDownOperation(this.name);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:countDownLatchService";
    }

    @Override
    public int getFactoryId() {
        return CountDownLatchPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 1;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("name", this.name);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("name");
    }

    @Override
    public Permission getRequiredPermission() {
        return new CountDownLatchPermission(this.name, "read");
    }
}

