/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.management.request;

import com.hazelcast.core.EntryView;
import com.hazelcast.core.IMap;
import com.hazelcast.management.ManagementCenterService;
import com.hazelcast.management.request.ConsoleRequest;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

public class GetMapEntryRequest
implements ConsoleRequest {
    private String mapName;
    private String type;
    private String key;

    public GetMapEntryRequest() {
    }

    public GetMapEntryRequest(String type, String mapName, String key) {
        this.type = type;
        this.mapName = mapName;
        this.key = key;
    }

    @Override
    public int getType() {
        return 12;
    }

    @Override
    public Object readResponse(ObjectDataInput in) throws IOException {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String[] temp = in.readUTF().split(":#");
            properties.put(temp[0], temp.length == 1 ? "" : temp[1]);
        }
        return properties;
    }

    @Override
    public void writeResponse(ManagementCenterService mcs, ObjectDataOutput dos) throws Exception {
        IMap map = mcs.getHazelcastInstance().getMap(this.mapName);
        EntryView entry = null;
        if (this.type.equals("string")) {
            entry = map.getEntryView(this.key);
        } else if (this.type.equals("long")) {
            entry = map.getEntryView(Long.valueOf(this.key));
        } else if (this.type.equals("integer")) {
            entry = map.getEntryView(Integer.valueOf(this.key));
        }
        TreeMap<String, String> result = new TreeMap<String, String>();
        if (entry == null) {
            result.put("No Value Found!", " ");
        } else {
            Object value = entry.getValue();
            result.put("browse_value", value != null ? value.toString() : "null");
            result.put("browse_class", value != null ? value.getClass().getName() : "null");
            result.put("memory_cost", Long.toString(entry.getCost()));
            result.put("date_creation_time", Long.toString(entry.getCreationTime()));
            result.put("date_expiration_time", Long.toString(entry.getExpirationTime()));
            result.put("browse_hits", Long.toString(entry.getHits()));
            result.put("date_access_time", Long.toString(entry.getLastAccessTime()));
            result.put("date_update_time", Long.toString(entry.getLastUpdateTime()));
            result.put("browse_version", Long.toString(entry.getVersion()));
        }
        dos.writeInt(result.size());
        for (Map.Entry propertyEntry : result.entrySet()) {
            dos.writeUTF((String)propertyEntry.getKey() + ":#" + (String)propertyEntry.getValue());
        }
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.type);
        out.writeUTF(this.mapName);
        out.writeUTF(this.key);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.type = in.readUTF();
        this.mapName = in.readUTF();
        this.key = in.readUTF();
    }
}

