/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.map.MapKeySet;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.operation.AbstractMapOperation;
import com.hazelcast.map.operation.EvictKeysBackupOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionAwareOperation;
import java.io.IOException;
import java.util.Set;

public class EvictKeysOperation
extends AbstractMapOperation
implements BackupAwareOperation,
PartitionAwareOperation {
    MapKeySet mapKeySet;
    boolean shouldBackup = true;

    public EvictKeysOperation() {
    }

    public EvictKeysOperation(String name, Set<Data> keys) {
        super(name);
        this.mapKeySet = new MapKeySet(keys);
    }

    @Override
    public void run() {
        RecordStore recordStore = this.mapService.getRecordStore(this.getPartitionId(), this.name);
        Set<Data> keys = this.mapKeySet.getKeySet();
        if (keys.isEmpty()) {
            this.shouldBackup = false;
        }
        for (Data key : keys) {
            if (recordStore.isLocked(key)) continue;
            recordStore.evict(key);
        }
    }

    @Override
    public boolean shouldBackup() {
        return this.shouldBackup;
    }

    @Override
    public int getSyncBackupCount() {
        return this.mapService.getMapContainer(this.name).getBackupCount();
    }

    @Override
    public int getAsyncBackupCount() {
        return this.mapService.getMapContainer(this.name).getAsyncBackupCount();
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public Operation getBackupOperation() {
        EvictKeysBackupOperation evictKeysBackupOperation = new EvictKeysBackupOperation(this.name, this.mapKeySet.getKeySet());
        evictKeysBackupOperation.setServiceName("hz:impl:mapService");
        return evictKeysBackupOperation;
    }

    public String toString() {
        return "EvictKeysOperation{}";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        this.mapKeySet.writeData(out);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.mapKeySet = new MapKeySet();
        this.mapKeySet.readData(in);
    }
}

