/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.map.RecordStore;
import com.hazelcast.map.operation.AbstractMapOperation;
import com.hazelcast.map.record.Record;
import com.hazelcast.map.record.RecordInfo;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupOperation;
import com.hazelcast.spi.PartitionAwareOperation;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PutAllBackupOperation
extends AbstractMapOperation
implements PartitionAwareOperation,
BackupOperation {
    private List<Map.Entry<Data, Data>> entries;
    private List<RecordInfo> recordInfos;
    private RecordStore recordStore;

    public PutAllBackupOperation(String name, List<Map.Entry<Data, Data>> entries, List<RecordInfo> recordInfos) {
        super(name);
        this.entries = entries;
        this.recordInfos = recordInfos;
    }

    public PutAllBackupOperation() {
    }

    @Override
    public void run() {
        int partitionId = this.getPartitionId();
        this.recordStore = this.mapService.getRecordStore(partitionId, this.name);
        for (int i = 0; i < this.entries.size(); ++i) {
            RecordInfo recordInfo = this.recordInfos.get(i);
            Map.Entry<Data, Data> entry = this.entries.get(i);
            Record record = this.recordStore.putBackup(entry.getKey(), entry.getValue(), -1L, false);
            this.mapService.applyRecordInfo(record, this.name, recordInfo);
        }
    }

    private void updateSizeEstimator(long recordSize) {
        this.recordStore.getSizeEstimator().add(recordSize);
    }

    private long calculateRecordSize(Record record) {
        return this.recordStore.getSizeEstimator().getCost(record);
    }

    @Override
    public Object getResponse() {
        return this.entries;
    }

    public String toString() {
        return "PutAllBackupOperation{}";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        int size = this.entries.size();
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            Map.Entry<Data, Data> entry = this.entries.get(i);
            entry.getKey().writeData(out);
            entry.getValue().writeData(out);
            this.recordInfos.get(i).writeData(out);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        this.entries = new ArrayList<Map.Entry<Data, Data>>(size);
        this.recordInfos = new ArrayList<RecordInfo>(size);
        for (int i = 0; i < size; ++i) {
            AbstractMap.SimpleImmutableEntry<Data, Data> entry = new AbstractMap.SimpleImmutableEntry<Data, Data>(IOUtil.readData(in), IOUtil.readData(in));
            this.entries.add(entry);
            RecordInfo recordInfo = new RecordInfo();
            recordInfo.readData(in);
            this.recordInfos.add(recordInfo);
        }
    }
}

