/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.operations;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.multimap.MultiMapContainer;
import com.hazelcast.multimap.MultiMapDataSerializerHook;
import com.hazelcast.multimap.MultiMapEvent;
import com.hazelcast.multimap.MultiMapEventFilter;
import com.hazelcast.multimap.MultiMapService;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionAwareOperation;
import java.io.IOException;
import java.util.Collection;

public abstract class MultiMapOperation
extends Operation
implements PartitionAwareOperation,
IdentifiedDataSerializable {
    protected String name;
    private transient MultiMapContainer container;
    protected transient Object response;

    protected MultiMapOperation() {
    }

    protected MultiMapOperation(String name) {
        this.name = name;
    }

    @Override
    public final Object getResponse() {
        return this.response;
    }

    @Override
    public final String getServiceName() {
        return "hz:impl:multiMapService";
    }

    @Override
    public void afterRun() throws Exception {
    }

    @Override
    public void beforeRun() throws Exception {
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    public final boolean hasListener() {
        EventService eventService = this.getNodeEngine().getEventService();
        Collection<EventRegistration> registrations = eventService.getRegistrations(this.getServiceName(), this.name);
        return registrations.size() > 0;
    }

    public final void publishEvent(EntryEventType eventType, Data key, Object value) {
        NodeEngine engine = this.getNodeEngine();
        EventService eventService = engine.getEventService();
        Collection<EventRegistration> registrations = eventService.getRegistrations("hz:impl:multiMapService", this.name);
        for (EventRegistration registration : registrations) {
            MultiMapEventFilter filter = (MultiMapEventFilter)registration.getFilter();
            if (filter.getKey() != null && !filter.getKey().equals(key)) continue;
            Data dataValue = filter.isIncludeValue() ? engine.toData(value) : null;
            MultiMapEvent event = new MultiMapEvent(this.name, key, dataValue, eventType, engine.getThisAddress());
            eventService.publishEvent("hz:impl:multiMapService", registration, (Object)event, this.name.hashCode());
        }
    }

    public final Object toObject(Object obj) {
        return this.getNodeEngine().toObject(obj);
    }

    public final Data toData(Object obj) {
        return this.getNodeEngine().toData(obj);
    }

    public final MultiMapContainer getOrCreateContainer() {
        if (this.container == null) {
            MultiMapService service = (MultiMapService)this.getService();
            this.container = service.getOrCreateCollectionContainer(this.getPartitionId(), this.name);
        }
        return this.container;
    }

    public final boolean isBinary() {
        return this.getOrCreateContainer().getConfig().isBinary();
    }

    public final int getSyncBackupCount() {
        return this.getOrCreateContainer().getConfig().getSyncBackupCount();
    }

    public final int getAsyncBackupCount() {
        return this.getOrCreateContainer().getConfig().getAsyncBackupCount();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
    }

    @Override
    public int getFactoryId() {
        return MultiMapDataSerializerHook.F_ID;
    }
}

