/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public final class UTFEncoderDecoder {
    private static final int STRING_CHUNK_SIZE = 16384;
    private static final UTFEncoderDecoder INSTANCE = UTFEncoderDecoder.buildUTFUtil();
    private final StringCreator stringCreator;
    private final boolean hazelcastEnterpriseActive;

    private UTFEncoderDecoder(boolean fastStringCreator) {
        this(fastStringCreator ? UTFEncoderDecoder.buildFastStringCreator() : new DefaultStringCreator(), false);
    }

    private UTFEncoderDecoder(StringCreator stringCreator, boolean hazelcastEnterpriseActive) {
        this.stringCreator = stringCreator;
        this.hazelcastEnterpriseActive = hazelcastEnterpriseActive;
    }

    public StringCreator getStringCreator() {
        return this.stringCreator;
    }

    public static void writeUTF(DataOutput out, String str, byte[] buffer) throws IOException {
        INSTANCE.writeUTF0(out, str, buffer);
    }

    public static String readUTF(DataInput in, byte[] buffer) throws IOException {
        return INSTANCE.readUTF0(in, buffer);
    }

    public boolean isHazelcastEnterpriseActive() {
        return this.hazelcastEnterpriseActive;
    }

    public void writeUTF0(DataOutput out, String str, byte[] buffer) throws IOException {
        boolean isNull = str == null;
        out.writeBoolean(isNull);
        if (isNull) {
            return;
        }
        int length = str.length();
        out.writeInt(length);
        if (length > 0) {
            int chunkSize = length / 16384 + 1;
            for (int i = 0; i < chunkSize; ++i) {
                int beginIndex = Math.max(0, i * 16384 - 1);
                int endIndex = Math.min((i + 1) * 16384 - 1, length);
                this.writeShortUTF(out, str, beginIndex, endIndex, buffer);
            }
        }
    }

    private void writeShortUTF(DataOutput out, String str, int beginIndex, int endIndex, byte[] buffer) throws IOException {
        char c;
        int i;
        int utfLength = 0;
        int count = 0;
        for (i = beginIndex; i < endIndex; ++i) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utfLength;
                continue;
            }
            if (c > '\u07ff') {
                utfLength += 3;
                continue;
            }
            utfLength += 2;
        }
        if (utfLength > 65535) {
            throw new UTFDataFormatException("encoded string too long:" + utfLength + " bytes");
        }
        out.writeShort(utfLength);
        for (i = beginIndex; i < endIndex && (c = str.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            this.buffering(buffer, count++, (byte)c, out);
        }
        while (i < endIndex) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.buffering(buffer, count++, (byte)c, out);
            } else if (c > '\u07ff') {
                this.buffering(buffer, count++, (byte)(0xE0 | c >> 12 & 0xF), out);
                this.buffering(buffer, count++, (byte)(0x80 | c >> 6 & 0x3F), out);
                this.buffering(buffer, count++, (byte)(0x80 | c & 0x3F), out);
            } else {
                this.buffering(buffer, count++, (byte)(0xC0 | c >> 6 & 0x1F), out);
                this.buffering(buffer, count++, (byte)(0x80 | c & 0x3F), out);
            }
            ++i;
        }
        int length = count % buffer.length;
        out.write(buffer, 0, length == 0 ? buffer.length : length);
    }

    public String readUTF0(DataInput in, byte[] buffer) throws IOException {
        boolean isNull = in.readBoolean();
        if (isNull) {
            return null;
        }
        int length = in.readInt();
        char[] data = new char[length];
        if (length > 0) {
            int chunkSize = length / 16384 + 1;
            for (int i = 0; i < chunkSize; ++i) {
                int beginIndex = Math.max(0, i * 16384 - 1);
                int endIndex = Math.min((i + 1) * 16384 - 1, length);
                this.readShortUTF(in, data, beginIndex, endIndex, buffer);
            }
        }
        return this.stringCreator.buildString(data);
    }

    private void readShortUTF(DataInput in, char[] data, int beginIndex, int endIndex, byte[] buffer) throws IOException {
        int utflen = in.readShort();
        int c = 0;
        int count = 0;
        int chararr_count = beginIndex;
        int lastCount = -1;
        while (count < utflen && (c = this.buffered(buffer, count, utflen, in) & 0xFF) <= 127) {
            lastCount = count++;
            data[chararr_count++] = (char)c;
        }
        block6: while (count < utflen) {
            if (lastCount > -1 && lastCount < count) {
                c = this.buffered(buffer, count, utflen, in) & 0xFF;
            }
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    lastCount = count++;
                    data[chararr_count++] = (char)c;
                    continue block6;
                }
                case 12: 
                case 13: {
                    byte char2;
                    lastCount = count++;
                    if (count + 1 > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    if (((char2 = this.buffered(buffer, count++, utflen, in)) & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + count);
                    }
                    data[chararr_count++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    lastCount = count++;
                    if (count + 2 > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = this.buffered(buffer, count++, utflen, in);
                    byte char3 = this.buffered(buffer, count++, utflen, in);
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                    }
                    data[chararr_count++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block6;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + count);
        }
    }

    private void buffering(byte[] buffer, int pos, byte value, DataOutput out) throws IOException {
        int innerPos = pos % buffer.length;
        if (pos > 0 && innerPos == 0) {
            out.write(buffer, 0, buffer.length);
        }
        buffer[innerPos] = value;
    }

    private byte buffered(byte[] buffer, int pos, int utfLenght, DataInput in) throws IOException {
        int innerPos = pos % buffer.length;
        if (innerPos == 0) {
            int length = Math.min(buffer.length, utfLenght - pos);
            in.readFully(buffer, 0, length);
        }
        return buffer[innerPos];
    }

    public static boolean useOldStringConstructor() {
        try {
            Class<String> clazz = String.class;
            clazz.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, char[].class);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static UTFEncoderDecoder buildUTFUtil() {
        try {
            Class<?> clazz = Class.forName("com.hazelcast.nio.utf8.EnterpriseStringCreator");
            Method method = clazz.getDeclaredMethod("findBestStringCreator", new Class[0]);
            return new UTFEncoderDecoder((StringCreator)method.invoke(clazz, new Object[0]), true);
        }
        catch (Throwable t) {
            boolean faststringEnabled = Boolean.parseBoolean(System.getProperty("hazelcast.nio.faststring", "true"));
            return new UTFEncoderDecoder(faststringEnabled ? UTFEncoderDecoder.buildFastStringCreator() : new DefaultStringCreator(), false);
        }
    }

    private static StringCreator buildFastStringCreator() {
        try {
            Constructor<String> constructor = null;
            constructor = UTFEncoderDecoder.useOldStringConstructor() ? String.class.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, char[].class) : String.class.getDeclaredConstructor(char[].class, Boolean.TYPE);
            if (constructor != null) {
                constructor.setAccessible(true);
                return new FastStringCreator(constructor);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static interface StringCreator {
        public String buildString(char[] var1);
    }

    private static class FastStringCreator
    implements StringCreator {
        private final Constructor<String> constructor;
        private final boolean useOldStringConstructor;

        public FastStringCreator(Constructor<String> constructor) {
            this.constructor = constructor;
            this.useOldStringConstructor = constructor.getParameterTypes().length == 3;
        }

        @Override
        public String buildString(char[] chars) {
            try {
                if (this.useOldStringConstructor) {
                    return this.constructor.newInstance(0, chars.length, chars);
                }
                return this.constructor.newInstance(chars, Boolean.TRUE);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class DefaultStringCreator
    implements StringCreator {
        private DefaultStringCreator() {
        }

        @Override
        public String buildString(char[] chars) {
            return new String(chars);
        }
    }
}

