/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.util.ConstructorFunction;
import java.util.concurrent.ConcurrentMap;

public class ConcurrencyUtil {
    private ConcurrencyUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> V getOrPutSynchronized(ConcurrentMap<K, V> map, K key, Object mutex, ConstructorFunction<K, V> func) {
        if (mutex == null) {
            throw new NullPointerException();
        }
        Object value = map.get(key);
        if (value == null) {
            Object object = mutex;
            synchronized (object) {
                value = map.get(key);
                if (value == null) {
                    value = func.createNew(key);
                    map.put(key, value);
                }
            }
        }
        return value;
    }

    public static <K, V> V getOrPutIfAbsent(ConcurrentMap<K, V> map, K key, ConstructorFunction<K, V> func) {
        Object value = map.get(key);
        if (value == null) {
            value = func.createNew(key);
            V current = map.putIfAbsent(key, value);
            value = current == null ? value : current;
        }
        return value;
    }
}

