/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util.executor;

import com.hazelcast.util.executor.StripedRunnable;
import com.hazelcast.util.executor.TimeoutRunnable;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class StripedExecutor
implements Executor {
    private final int size;
    private final Executor executor;
    private final Worker[] workers;
    private final Random rand = new Random();
    private final int maximumQueueSize;
    private volatile boolean live = true;

    public StripedExecutor(Executor executor, int workerCount) {
        this(executor, workerCount, Integer.MAX_VALUE);
    }

    public StripedExecutor(Executor executor, int workerCount, int maximumQueueSize) {
        this.maximumQueueSize = maximumQueueSize;
        this.size = workerCount;
        this.executor = executor;
        this.workers = new Worker[workerCount];
        for (int i = 0; i < workerCount; ++i) {
            this.workers[i] = new Worker();
        }
    }

    public int getWorkQueueSize() {
        int size = 0;
        for (Worker worker : this.workers) {
            size += worker.workQueue.size();
        }
        return size;
    }

    @Override
    public void execute(Runnable command) {
        int key = command instanceof StripedRunnable ? ((StripedRunnable)command).getKey() : this.rand.nextInt();
        if (!this.live) {
            throw new RejectedExecutionException("Executor is terminated!");
        }
        int index = key != Integer.MIN_VALUE ? Math.abs(key) % this.size : 0;
        this.workers[index].execute(command);
    }

    public void shutdown() {
        this.live = false;
        for (Worker worker : this.workers) {
            worker.workQueue.clear();
        }
    }

    public boolean isLive() {
        return this.live;
    }

    static /* synthetic */ int access$200(StripedExecutor x0) {
        return x0.maximumQueueSize;
    }

    private class Worker
    implements Executor,
    Runnable {
        private final AtomicBoolean scheduled = new AtomicBoolean(false);
        private final BlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(StripedExecutor.access$200(StripedExecutor.this));

        private Worker() {
        }

        @Override
        public void execute(Runnable command) {
            boolean offered;
            long timeout = 0L;
            TimeUnit timeUnit = TimeUnit.SECONDS;
            if (command instanceof TimeoutRunnable) {
                TimeoutRunnable timeoutRunnable = (TimeoutRunnable)command;
                timeout = timeoutRunnable.getTimeout();
                timeUnit = timeoutRunnable.getTimeUnit();
            }
            try {
                offered = timeout == 0L ? this.workQueue.offer(command) : this.workQueue.offer(command, timeout, timeUnit);
            }
            catch (InterruptedException e) {
                throw new RejectedExecutionException("Thread is interrupted while offering work");
            }
            if (!offered) {
                throw new RejectedExecutionException("Worker queue is full!");
            }
            this.schedule();
        }

        private void schedule() {
            if (this.scheduled.get()) {
                return;
            }
            if (!this.workQueue.isEmpty() && this.scheduled.compareAndSet(false, true)) {
                try {
                    StripedExecutor.this.executor.execute(this);
                }
                catch (RejectedExecutionException e) {
                    this.scheduled.set(false);
                    throw e;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Runnable r;
                do {
                    if ((r = (Runnable)this.workQueue.poll()) == null) continue;
                    r.run();
                } while (r != null);
            }
            finally {
                this.scheduled.set(false);
                this.schedule();
            }
        }
    }
}

