/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.eventbus.impl;

import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.eventbus.impl.BaseMessage;

class FloatMessage
extends BaseMessage<Float> {
    FloatMessage(boolean send, String address, Float body) {
        super(send, address, body);
    }

    public FloatMessage(Buffer readBuff) {
        super(readBuff);
    }

    @Override
    protected void readBody(int pos, Buffer readBuff) {
        boolean isNull;
        boolean bl = isNull = readBuff.getByte(pos) == 0;
        if (!isNull) {
            this.body = Float.valueOf(readBuff.getFloat(++pos));
        }
    }

    @Override
    protected void writeBody(Buffer buff) {
        if (this.body == null) {
            buff.appendByte((byte)0);
        } else {
            buff.appendByte((byte)1);
            buff.appendFloat(((Float)this.body).floatValue());
        }
    }

    @Override
    protected int getBodyLength() {
        return 1 + (this.body == null ? 0 : 4);
    }

    @Override
    protected Message<Float> copy() {
        return this;
    }

    @Override
    protected byte type() {
        return 7;
    }
}

