/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.framework.vertx;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.concurrent.ExecutorService;
import org.apache.commons.io.IOUtils;
import org.vertx.java.core.Context;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.streams.ReadStream;

public class AsyncInputStream
implements ReadStream<AsyncInputStream> {
    public static final int STATUS_PAUSED = 0;
    public static final int STATUS_ACTIVE = 1;
    public static final int STATUS_CLOSED = 2;
    static final int DEFAULT_CHUNK_SIZE = 8192;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final Vertx vertx;
    private final ExecutorService executor;
    private final PushbackInputStream in;
    private final int chunkSize;
    private int state = 1;
    private Handler<Void> closeHandler;
    private Handler<Buffer> dataHandler;
    private Handler<Throwable> failureHandler;
    private int offset;
    private Context context;

    public AsyncInputStream(Vertx vertx, ExecutorService executor, InputStream in) {
        this(vertx, executor, in, 8192);
    }

    public AsyncInputStream(Vertx vertx, ExecutorService executor, InputStream in, int chunkSize) {
        if (in == null) {
            throw new NullPointerException("in");
        }
        if (vertx == null) {
            throw new NullPointerException("vertx");
        }
        this.vertx = vertx;
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("chunkSize: " + chunkSize + " (expected: a positive integer)");
        }
        this.in = in instanceof PushbackInputStream ? (PushbackInputStream)in : new PushbackInputStream(in);
        this.chunkSize = chunkSize;
        this.executor = executor;
    }

    public int getState() {
        return this.state;
    }

    @Override
    public AsyncInputStream endHandler(Handler<Void> endHandler) {
        this.closeHandler = endHandler;
        return this;
    }

    @Override
    public AsyncInputStream dataHandler(Handler<Buffer> handler) {
        if (handler == null) {
            throw new IllegalArgumentException("handler");
        }
        this.dataHandler = handler;
        this.doRead();
        return this;
    }

    private void doRead() {
        if (this.context == null) {
            this.context = this.vertx.currentContext();
        }
        if (this.state == 1) {
            final Handler<Buffer> dataHandler = this.dataHandler;
            final Handler<Void> closeHandler = this.closeHandler;
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        final byte[] bytes = AsyncInputStream.this.readChunk();
                        if (bytes == null || bytes.length == 0) {
                            AsyncInputStream.this.state = 2;
                            IOUtils.closeQuietly((InputStream)AsyncInputStream.this.in);
                            AsyncInputStream.this.context.runOnContext(new Handler<Void>(){

                                @Override
                                public void handle(Void event) {
                                    if (closeHandler != null) {
                                        closeHandler.handle(null);
                                    }
                                }
                            });
                        } else {
                            AsyncInputStream.this.context.runOnContext(new Handler<Void>(){

                                @Override
                                public void handle(Void event) {
                                    dataHandler.handle(new Buffer(bytes));
                                    AsyncInputStream.this.doRead();
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        AsyncInputStream.this.state = 2;
                        IOUtils.closeQuietly((InputStream)AsyncInputStream.this.in);
                        AsyncInputStream.this.context.runOnContext(new Handler<Void>(){

                            @Override
                            public void handle(Void event) {
                                if (AsyncInputStream.this.failureHandler != null) {
                                    AsyncInputStream.this.failureHandler.handle(e);
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    @Override
    public AsyncInputStream pause() {
        if (this.state == 1) {
            this.state = 0;
        }
        return this;
    }

    @Override
    public AsyncInputStream resume() {
        switch (this.state) {
            case 2: {
                throw new IllegalStateException("Cannot resume, already closed");
            }
            case 0: {
                this.state = 1;
                this.doRead();
            }
        }
        return this;
    }

    @Override
    public AsyncInputStream exceptionHandler(Handler<Throwable> handler) {
        this.failureHandler = handler;
        return this;
    }

    public long transferredBytes() {
        return this.offset;
    }

    public boolean isClosed() {
        return this.state == 2;
    }

    public boolean isEndOfInput() throws Exception {
        int b = this.in.read();
        if (b < 0) {
            return true;
        }
        this.in.unread(b);
        return false;
    }

    private byte[] readChunk() throws Exception {
        if (this.isEndOfInput()) {
            return EMPTY_BYTE_ARRAY;
        }
        try {
            byte[] tmp = new byte[this.chunkSize];
            int readBytes = this.in.read(tmp);
            if (readBytes <= 0) {
                return null;
            }
            byte[] buffer = new byte[readBytes];
            System.arraycopy(tmp, 0, buffer, 0, readBytes);
            this.offset += readBytes;
            return buffer;
        }
        catch (IOException e) {
            IOUtils.closeQuietly((InputStream)this.in);
            throw e;
        }
    }

    public AsyncInputStream setContext(Context context) {
        this.context = context;
        return this;
    }

    private Context context() {
        if (this.context == null) {
            return this.vertx.currentContext();
        }
        return this.context;
    }
}

