/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.framework.vertx;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.ServerCookieEncoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.VoidHandler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.http.HttpServerResponse;
import org.vertx.java.core.streams.Pump;
import org.wisdom.api.bodies.NoHttpBody;
import org.wisdom.api.concurrent.ManagedFutureTask;
import org.wisdom.api.exceptions.ExceptionMapper;
import org.wisdom.api.exceptions.HttpException;
import org.wisdom.api.http.AsyncResult;
import org.wisdom.api.http.Context;
import org.wisdom.api.http.Renderable;
import org.wisdom.api.http.Request;
import org.wisdom.api.http.Result;
import org.wisdom.api.http.Results;
import org.wisdom.api.router.Route;
import org.wisdom.framework.vertx.AsyncInputStream;
import org.wisdom.framework.vertx.BuildConstants;
import org.wisdom.framework.vertx.ContextFromVertx;
import org.wisdom.framework.vertx.HttpUtils;
import org.wisdom.framework.vertx.RequestFromVertx;
import org.wisdom.framework.vertx.Server;
import org.wisdom.framework.vertx.ServiceAccessor;
import org.wisdom.framework.vertx.cookies.CookieHelper;

public class HttpHandler
implements Handler<HttpServerRequest> {
    private static final String SERVER_NAME = "Wisdom-Framework/" + BuildConstants.WISDOM_VERSION + " VertX/" + BuildConstants.VERTX_VERSION;
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpHandler.class);
    private final ServiceAccessor accessor;
    private final Vertx vertx;
    private final Server configuration;

    public HttpHandler(Vertx vertx, ServiceAccessor accessor, Server server) {
        this.accessor = accessor;
        this.vertx = vertx;
        this.configuration = server;
    }

    @Override
    public void handle(HttpServerRequest request) {
        LOGGER.debug("A request has arrived on the server : {} {}", (Object)request.method(), (Object)request.path());
        final ContextFromVertx context = new ContextFromVertx(this.vertx, this.accessor, request);
        if (!this.configuration.accept(request.path())) {
            LOGGER.warn("Request on {} denied by {}", (Object)request.path(), (Object)this.configuration.name());
            request.endHandler(new VoidHandler(){

                @Override
                public void handle() {
                    HttpHandler.this.writeResponse(context, (RequestFromVertx)context.request(), HttpHandler.this.configuration.getOnDeniedResult(), false);
                }
            });
        } else {
            request.endHandler(new VoidHandler(){

                @Override
                public void handle() {
                    if (context.ready()) {
                        HttpHandler.this.dispatch(context, (RequestFromVertx)context.request());
                    } else {
                        HttpHandler.this.writeResponse(context, (RequestFromVertx)context.request(), Results.badRequest((String)"Request processing failed"), false);
                    }
                }
            });
        }
    }

    private static void cleanup(ContextFromVertx context) {
        if (context != null) {
            context.cleanup();
        }
        Context.CONTEXT.remove();
    }

    private void dispatch(ContextFromVertx context, RequestFromVertx request) {
        Result result;
        LOGGER.debug("Dispatching {} {}", (Object)context.request().method(), (Object)context.path());
        Context.CONTEXT.set(context);
        Route route = this.accessor.getRouter().getRouteFor(context.request().method(), context.path(), (Request)request);
        if (route == null) {
            LOGGER.error("The router has returned 'null' instead of an unbound route for " + context.path());
            result = Results.notFound();
        } else {
            context.route(route);
            result = this.invoke(route);
            if (result instanceof AsyncResult) {
                this.handleAsyncResult(context, request, (AsyncResult)result);
                return;
            }
        }
        try {
            this.writeResponse(context, request, result, true);
        }
        catch (Exception e) {
            LOGGER.error("Cannot write response", (Throwable)e);
            result = Results.internalServerError((Throwable)e);
            try {
                this.writeResponse(context, request, result, false);
            }
            catch (Exception e1) {
                LOGGER.error("Cannot even write the error response...", (Throwable)e1);
            }
        }
    }

    private Result invoke(Route route) {
        try {
            return route.invoke();
        }
        catch (Throwable e) {
            if (e.getCause() != null) {
                LOGGER.error("An error occurred during route invocation", e.getCause());
                return Results.internalServerError((Throwable)e.getCause());
            }
            LOGGER.error("An error occurred during route invocation", e);
            return Results.internalServerError((Throwable)e);
        }
    }

    private void handleAsyncResult(final ContextFromVertx context, final RequestFromVertx request, final AsyncResult asyncResult) {
        ManagedFutureTask future = this.accessor.getExecutor().submit(asyncResult.callable());
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<Result>(){

            public void onSuccess(Result result) {
                Map headers = result.getHeaders();
                for (Map.Entry header : asyncResult.getHeaders().entrySet()) {
                    if (headers.containsKey(header.getKey())) continue;
                    headers.put(header.getKey(), header.getValue());
                }
                HttpHandler.this.writeResponse(context, request, result, true);
            }

            public void onFailure(Throwable t) {
                ExceptionMapper mapper;
                if (t instanceof HttpException) {
                    HttpHandler.this.writeResponse(context, request, ((HttpException)t).toResult(), false);
                    return;
                }
                if (t instanceof Exception && (mapper = HttpHandler.this.accessor.getExceptionMapper((Exception)t)) != null) {
                    HttpHandler.this.writeResponse(context, request, mapper.toResult((Exception)t), false);
                    return;
                }
                HttpHandler.this.writeResponse(context, request, Results.internalServerError((Throwable)t), false);
            }
        });
    }

    private void writeResponse(ContextFromVertx context, RequestFromVertx request, Result result, boolean handleFlashAndSessionCookie) {
        InputStream stream;
        Renderable renderable = result.getRenderable();
        if (renderable == null) {
            renderable = NoHttpBody.INSTANCE;
        }
        boolean success = true;
        try {
            stream = HttpUtils.processResult(this.accessor, context, renderable, result);
        }
        catch (Exception e) {
            LOGGER.error("Cannot render the response to " + request.uri(), (Throwable)e);
            stream = new ByteArrayInputStream(NoHttpBody.empty());
            success = false;
        }
        long length = renderable.length();
        if (length == 0L && result.getHeaders().get("Content-Length") != null) {
            length = Long.valueOf((String)result.getHeaders().get("Content-Length"));
        }
        if (length != 0L && this.shouldEncodingBeDisabledForResponse(length)) {
            LOGGER.debug("Disabling encoding for {} - size not in range", (Object)request.path());
            result.with("X-Wisdom-Disabled-Encoding", "true");
        }
        this.finalizeWriteReponse(context, request.getVertxRequest(), result, stream, success, handleFlashAndSessionCookie);
    }

    /*
     * WARNING - void declaration
     */
    private void finalizeWriteReponse(final ContextFromVertx context, final HttpServerRequest request, Result result, InputStream stream, boolean success, boolean handleFlashAndSessionCookie) {
        String fullContentType;
        Renderable renderable = result.getRenderable();
        if (renderable == null) {
            renderable = NoHttpBody.INSTANCE;
        }
        boolean keepAlive = HttpUtils.isKeepAlive(request);
        final HttpServerResponse response = request.response();
        for (Map.Entry entry : result.getHeaders().entrySet()) {
            response.putHeader((String)entry.getKey(), (String)entry.getValue());
        }
        if (!result.getHeaders().containsKey("Server")) {
            response.putHeader("Server", SERVER_NAME);
        }
        if ((fullContentType = result.getFullContentType()) == null) {
            response.putHeader("Content-Type", renderable.mimetype());
        } else {
            response.putHeader("Content-Type", fullContentType);
        }
        if (handleFlashAndSessionCookie) {
            context.flash().save((Context)context, result);
            context.session().save((Context)context, result);
        }
        for (org.wisdom.api.cookies.Cookie cookie : result.getCookies()) {
            String encoded = ServerCookieEncoder.encode((Cookie)CookieHelper.convertWisdomCookieToNettyCookie(cookie));
            response.headers().add("Set-Cookie", encoded);
        }
        response.setStatusCode(HttpUtils.getStatusFromResult(result, success));
        if (renderable.mustBeChunked()) {
            LOGGER.debug("Building the chunked response for {} {} ({})", new Object[]{request.method(), request.uri(), context});
            if (renderable.length() > 0L && !response.headers().contains("Content-Length")) {
                response.putHeader("Content-Length", Long.toString(renderable.length()));
            }
            if (!response.headers().contains("Content-Type")) {
                response.putHeader("Content-Type", "application/octet-stream");
            }
            response.setChunked(true);
            response.putHeader("Transfer-Encoding", "chunked");
            response.putHeader("Connection", "close");
            AsyncInputStream asyncInputStream = new AsyncInputStream(this.vertx, (ExecutorService)this.accessor.getExecutor(), stream);
            asyncInputStream.setContext(context.vertxContext());
            final Pump pump = Pump.createPump(asyncInputStream, response);
            asyncInputStream.endHandler((Handler)new Handler<Void>(){

                @Override
                public void handle(Void event) {
                    context.vertxContext().runOnContext(new Handler<Void>(){

                        @Override
                        public void handle(Void event) {
                            LOGGER.debug("Ending chunked response for {} - {} bytes", (Object)request.uri(), (Object)pump.bytesPumped());
                            response.end();
                            response.close();
                            HttpHandler.cleanup(context);
                        }
                    });
                }
            });
            asyncInputStream.exceptionHandler((Handler)new Handler<Throwable>(){

                @Override
                public void handle(Throwable event) {
                    context.vertxContext().runOnContext(new Handler<Void>(){

                        @Override
                        public void handle(Void event) {
                            LOGGER.error("Cannot read the result stream", (Object)event);
                            response.close();
                            HttpHandler.cleanup(context);
                        }
                    });
                }
            });
            context.vertxContext().runOnContext(new Handler<Void>(){

                @Override
                public void handle(Void event) {
                    pump.start();
                }
            });
        } else {
            void var11_16;
            byte[] byArray = new byte[]{};
            try {
                byte[] byArray2 = IOUtils.toByteArray((InputStream)stream);
            }
            catch (IOException e) {
                LOGGER.error("Cannot copy the response to {}", (Object)request.uri(), (Object)e);
            }
            if (!response.headers().contains("Content-Length")) {
                response.putHeader("Content-Length", Long.toString(((void)var11_16).length));
            }
            if (keepAlive) {
                response.putHeader("Connection", "keep-alive");
            }
            response.write(new Buffer((byte[])var11_16));
            if (HttpUtils.isKeepAlive(request)) {
                response.end();
            } else {
                response.end();
                response.close();
            }
            HttpHandler.cleanup(context);
        }
    }

    private boolean shouldEncodingBeDisabledForResponse(long length) {
        return this.configuration.hasCompressionEnabled() && (length < this.configuration.getEncodingMinBound() || length > this.configuration.getEncodingMaxBound());
    }
}

