/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.framework.vertx;

import java.io.InputStream;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.http.HttpVersion;
import org.wisdom.api.bodies.NoHttpBody;
import org.wisdom.api.content.ContentSerializer;
import org.wisdom.api.http.Context;
import org.wisdom.api.http.HttpMethod;
import org.wisdom.api.http.Renderable;
import org.wisdom.api.http.Result;
import org.wisdom.framework.vertx.HttpHandler;
import org.wisdom.framework.vertx.ServiceAccessor;

public class HttpUtils {
    public static final String CLOSE = "close";
    public static final String KEEP_ALIVE = "keep-alive";

    public static boolean isKeepAlive(HttpServerRequest request) {
        String connection = request.headers().get("Connection");
        if (connection != null && connection.equalsIgnoreCase(CLOSE)) {
            return false;
        }
        if (request.version() == HttpVersion.HTTP_1_1) {
            return !CLOSE.equalsIgnoreCase(connection);
        }
        return KEEP_ALIVE.equalsIgnoreCase(connection);
    }

    public static int getStatusFromResult(Result result, boolean success) {
        if (!success) {
            return 400;
        }
        return result.getStatusCode();
    }

    public static InputStream processResult(ServiceAccessor accessor, Context context, Renderable renderable, Result result) throws Exception {
        if (renderable.requireSerializer()) {
            ContentSerializer serializer = null;
            if (result.getContentType() != null) {
                serializer = accessor.getContentEngines().getContentSerializerForContentType(result.getContentType());
            }
            if (serializer == null && (serializer = accessor.getContentEngines().getBestSerializer(context.request().mediaTypes())) != null) {
                result.with("Content-Type", serializer.getContentType());
            }
            if (serializer != null) {
                serializer.serialize(renderable);
            } else {
                LoggerFactory.getLogger(HttpHandler.class).error("Cannot find a serializer to handle the request (explicit content type: {}, accept media types: {}), returning content as String", (Object)result.getContentType(), (Object)context.request().mediaTypes());
                if (renderable.content() != null) {
                    renderable.setSerializedForm(renderable.content().toString());
                    result.with("Content-Type", "text/plain");
                } else {
                    renderable = NoHttpBody.INSTANCE;
                    result.with("Content-Type", "text/plain");
                }
            }
        }
        return renderable.render(context, result);
    }

    public static String getContentTypeFromContentTypeAndCharacterSetting(String rawContentType) {
        if (rawContentType.contains(";")) {
            return rawContentType.split(";")[0];
        }
        return rawContentType;
    }

    public static boolean isPostOrPut(HttpServerRequest request) {
        return request.method().equalsIgnoreCase(HttpMethod.POST.name()) || request.method().equalsIgnoreCase(HttpMethod.PUT.name());
    }
}

