/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.framework.vertx;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.net.MediaType;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.vertx.java.core.Handler;
import org.vertx.java.core.MultiMap;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpServerFileUpload;
import org.vertx.java.core.http.HttpServerRequest;
import org.wisdom.api.configuration.ApplicationConfiguration;
import org.wisdom.api.cookies.Cookie;
import org.wisdom.api.cookies.Cookies;
import org.wisdom.api.http.Request;
import org.wisdom.framework.vertx.ContextFromVertx;
import org.wisdom.framework.vertx.HttpUtils;
import org.wisdom.framework.vertx.cookies.CookiesImpl;
import org.wisdom.framework.vertx.file.MixedFileUpload;
import org.wisdom.framework.vertx.file.VertxFileUpload;

public class RequestFromVertx
extends Request {
    private final HttpServerRequest request;
    private final Cookies cookies;
    private List<VertxFileUpload> files = Lists.newArrayList();
    private Buffer raw = new Buffer(0);
    private final Map<String, Object> data;
    private Map<String, List<String>> formData;
    private Map<String, List<String>> headers;

    public RequestFromVertx(final ContextFromVertx context, HttpServerRequest request, final ApplicationConfiguration configuration) {
        this.request = request;
        if (HttpUtils.isPostOrPut(request)) {
            this.request.expectMultiPart(true);
            this.request.uploadHandler(new Handler<HttpServerFileUpload>(){

                @Override
                public void handle(HttpServerFileUpload upload) {
                    RequestFromVertx.this.files.add(new MixedFileUpload(context.vertx(), upload, configuration.getLongWithDefault("http.upload.disk.threshold", Long.valueOf(16384L)), configuration.getLongWithDefault("http.upload.max", Long.valueOf(-1L))));
                }
            });
        }
        this.cookies = new CookiesImpl(request);
        this.data = new HashMap<String, Object>();
        this.request.dataHandler(new Handler<Buffer>(){

            @Override
            public void handle(Buffer event) {
                boolean exceeded;
                if (event == null) {
                    return;
                }
                boolean bl = exceeded = RequestFromVertx.this.raw.length() >= configuration.getIntegerWithDefault("request.body.max.size", Integer.valueOf(102400));
                if (!exceeded) {
                    RequestFromVertx.this.raw.appendBuffer(event);
                }
            }
        });
    }

    public String contentType() {
        return this.request.headers().get("Content-Type");
    }

    public String encoding() {
        return this.request.headers().get("Accept-Encoding");
    }

    public String language() {
        return this.request.headers().get("Accept-Language");
    }

    public String charset() {
        return this.request.headers().get("Accept-Charset");
    }

    public String uri() {
        return this.request.uri();
    }

    public String method() {
        return this.request.method();
    }

    public String remoteAddress() {
        if (this.headers().containsKey("X-Forwarded-For")) {
            return this.getHeader("X-Forwarded-For");
        }
        InetSocketAddress remote = this.request.remoteAddress();
        return remote.getAddress().getHostAddress();
    }

    public String host() {
        InetSocketAddress remote = this.request.remoteAddress();
        return remote.getHostName();
    }

    public String path() {
        try {
            return new URI(this.request.uri()).getRawPath();
        }
        catch (URISyntaxException e) {
            return this.uri();
        }
    }

    public MediaType mediaType() {
        Collection<MediaType> types = this.mediaTypes();
        if (types == null || types.isEmpty()) {
            return MediaType.ANY_TEXT_TYPE;
        }
        if (types.size() == 1 && types.iterator().next().equals((Object)MediaType.ANY_TYPE)) {
            return MediaType.ANY_TEXT_TYPE;
        }
        return types.iterator().next();
    }

    public Collection<MediaType> mediaTypes() {
        String[] segments;
        String contentType = this.request.headers().get("Accept");
        if (contentType == null) {
            return ImmutableList.of((Object)MediaType.ANY_TEXT_TYPE);
        }
        TreeSet<MediaType> set = new TreeSet<MediaType>(new Comparator<MediaType>(){

            @Override
            public int compare(MediaType o1, MediaType o2) {
                double q1 = 1.0;
                double q2 = 1.0;
                ImmutableList ql1 = o1.parameters().get((Object)"q");
                ImmutableList ql2 = o2.parameters().get((Object)"q");
                if (ql1 != null && !ql1.isEmpty()) {
                    q1 = Double.parseDouble((String)ql1.get(0));
                }
                if (ql2 != null && !ql2.isEmpty()) {
                    q2 = Double.parseDouble((String)ql2.get(0));
                }
                return new Double(q2).compareTo(q1);
            }
        });
        for (String segment : segments = contentType.split(",")) {
            MediaType type = MediaType.parse((String)segment.trim());
            set.add(type);
        }
        return set;
    }

    public boolean accepts(String mimeType) {
        String contentType = this.request.headers().get("Accept");
        if (contentType == null) {
            contentType = "text/html";
        }
        if (contentType.contains(mimeType)) {
            return true;
        }
        MediaType input = MediaType.parse((String)mimeType);
        for (MediaType type : this.mediaTypes()) {
            if (!input.is(type)) continue;
            return true;
        }
        return false;
    }

    public Cookies cookies() {
        return this.cookies;
    }

    public Cookie cookie(String name) {
        return this.cookies.get(name);
    }

    public Map<String, List<String>> headers() {
        if (this.headers != null) {
            return this.headers;
        }
        this.headers = new HashMap<String, List<String>>();
        MultiMap requestHeaders = this.request.headers();
        Set<String> names = requestHeaders.names();
        for (String name : names) {
            this.headers.put(name, requestHeaders.getAll(name));
        }
        return this.headers;
    }

    public String parameter(String name) {
        String s = this.request.params().get(name);
        if (s == null) {
            List<String> l;
            if (this.formData != null && (l = this.formData.get(name)) != null && !l.isEmpty()) {
                return l.get(0);
            }
            return null;
        }
        return s;
    }

    public List<String> parameterMultipleValues(String name) {
        return this.request.params().getAll(name);
    }

    public String parameter(String name, String defaultValue) {
        String v = this.request.params().get(name);
        return v != null ? v : defaultValue;
    }

    public Integer parameterAsInteger(String name) {
        String parameter = this.parameter(name);
        try {
            return Integer.parseInt(parameter);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Integer parameterAsInteger(String name, Integer defaultValue) {
        Integer parameter = this.parameterAsInteger(name);
        if (parameter == null) {
            return defaultValue;
        }
        return parameter;
    }

    public Boolean parameterAsBoolean(String name) {
        String parameter = this.parameter(name);
        try {
            return Boolean.parseBoolean(parameter);
        }
        catch (Exception e) {
            return false;
        }
    }

    public Boolean parameterAsBoolean(String name, boolean defaultValue) {
        if (!this.request.params().contains(name)) {
            return defaultValue;
        }
        Boolean parameter = this.parameterAsBoolean(name);
        if (parameter == null) {
            return defaultValue;
        }
        return parameter;
    }

    public Map<String, List<String>> parameters() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (String key : this.request.params().names()) {
            result.put(key, this.request.params().getAll(key));
        }
        return result;
    }

    public Map<String, Object> data() {
        return this.data;
    }

    public HttpServerRequest getVertxRequest() {
        return this.request;
    }

    public Map<String, List<String>> getFormData() {
        return this.formData;
    }

    public String getRawBodyAsString() {
        if (this.raw == null) {
            return null;
        }
        return this.raw.toString(Charsets.UTF_8.displayName());
    }

    public byte[] getRawBody() {
        return this.raw.getBytes();
    }

    public List<VertxFileUpload> getFiles() {
        return this.files;
    }

    public boolean ready() {
        for (VertxFileUpload file : this.files) {
            if (file.getErrorIfAny() == null) continue;
            return false;
        }
        String contentType = this.request.headers().get("Content-Type");
        if (contentType != null) {
            contentType = HttpUtils.getContentTypeFromContentTypeAndCharacterSetting(contentType);
            if (HttpUtils.isPostOrPut(this.request) && (contentType.equalsIgnoreCase("application/x-www-form-urlencoded") || contentType.equalsIgnoreCase("multipart/form-data"))) {
                this.formData = new HashMap<String, List<String>>();
                for (String key : this.request.formAttributes().names()) {
                    this.formData.put(key, this.request.formAttributes().getAll(key));
                }
                return true;
            }
        }
        this.formData = new HashMap<String, List<String>>();
        return true;
    }
}

