/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.framework.vertx;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.sockjs.SockJSSocket;
import org.wisdom.framework.vertx.ServiceAccessor;
import org.wisdom.framework.vertx.Socket;

public class SockJsHandler
implements Handler<SockJSSocket> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SockJsHandler.class);
    private final ServiceAccessor accessor;
    private final String prefix;

    public SockJsHandler(ServiceAccessor accessor, String prefix) {
        this.accessor = accessor;
        this.prefix = prefix;
    }

    @Override
    public void handle(final SockJSSocket socket) {
        LOGGER.info("New sockJS connection {}, {}", (Object)socket, (Object)socket.uri());
        final Socket sock = new Socket(socket);
        this.accessor.getDispatcher().addSocket(this.prefix, sock);
        socket.endHandler(new Handler<Void>(){

            @Override
            public void handle(Void event) {
                LOGGER.info("Socket JS closed {}, {}", (Object)socket, (Object)socket.uri());
                SockJsHandler.this.accessor.getDispatcher().removeSocket(SockJsHandler.this.prefix, sock);
            }
        });
        socket.dataHandler(new Handler<Buffer>(){

            @Override
            public void handle(Buffer event) {
                SockJsHandler.this.accessor.getDispatcher().received(SockJsHandler.this.prefix, event.getBytes(), sock);
            }
        });
    }
}

