/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.framework.vertx;

import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.eventbus.EventBus;
import org.vertx.java.core.http.ServerWebSocket;
import org.vertx.java.core.sockjs.SockJSSocket;

public class Socket {
    private final Object delegate;

    public Socket(ServerWebSocket delegate) {
        this.delegate = delegate;
    }

    public Socket(SockJSSocket delegate) {
        this.delegate = delegate;
    }

    private String getWriteHandlerId() {
        if (this.delegate instanceof ServerWebSocket) {
            return ((ServerWebSocket)this.delegate).textHandlerID();
        }
        if (this.delegate instanceof SockJSSocket) {
            return ((SockJSSocket)this.delegate).writeHandlerID();
        }
        throw new IllegalArgumentException("Unsupported socket type " + this.delegate);
    }

    private String getBinaryWriteHandlerId() {
        if (this.delegate instanceof ServerWebSocket) {
            return ((ServerWebSocket)this.delegate).binaryHandlerID();
        }
        if (this.delegate instanceof SockJSSocket) {
            return ((SockJSSocket)this.delegate).writeHandlerID();
        }
        throw new IllegalArgumentException("Unsupported socket type " + this.delegate);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Socket socket = (Socket)o;
        return this.delegate.equals(socket.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String path() {
        if (this.delegate instanceof ServerWebSocket) {
            return ((ServerWebSocket)this.delegate).path();
        }
        if (this.delegate instanceof SockJSSocket) {
            return ((SockJSSocket)this.delegate).uri();
        }
        throw new IllegalArgumentException("Unsupported socket type " + this.delegate);
    }

    public void publish(String message, EventBus bus) {
        if (this.delegate instanceof ServerWebSocket) {
            bus.publish(this.getWriteHandlerId(), message);
        } else if (this.delegate instanceof SockJSSocket) {
            bus.publish(this.getWriteHandlerId(), new Buffer().appendString(message));
        }
    }

    public void publish(byte[] message, EventBus bus) {
        if (this.delegate instanceof ServerWebSocket) {
            bus.publish(this.getBinaryWriteHandlerId(), new Buffer().appendBytes(message));
        } else if (this.delegate instanceof SockJSSocket) {
            bus.publish(this.getBinaryWriteHandlerId(), new Buffer().appendBytes(message));
        }
    }
}

