/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.framework.vertx;

import java.io.File;
import java.util.Hashtable;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Context;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.Validate;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.eventbus.EventBus;
import org.vertx.java.core.impl.DefaultVertx;
import org.vertx.java.core.logging.impl.SLF4JLogDelegateFactory;
import org.vertx.java.spi.cluster.impl.hazelcast.HazelcastClusterManagerFactory;
import org.wisdom.api.configuration.Configuration;

@Component
@Instantiate
public class VertxSingleton
implements Pojo {
    InstanceManager __IM;
    private boolean __Fcontext;
    @Context
    protected BundleContext context;
    private boolean __Fconfiguration;
    @Requires(optional=true, filter="(configuration.path=vertx)")
    Configuration configuration;
    private boolean __Fvertx;
    private Vertx vertx;
    private boolean __FvertxRegistration;
    private ServiceRegistration<Vertx> vertxRegistration;
    private boolean __FbusRegistration;
    private ServiceRegistration<EventBus> busRegistration;
    boolean __Mstart;
    boolean __Mstop;

    BundleContext __getcontext() {
        if (!this.__Fcontext) {
            return this.context;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "context");
    }

    void __setcontext(BundleContext bundleContext) {
        if (!this.__Fcontext) {
            this.context = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "context", (Object)bundleContext);
    }

    Configuration __getconfiguration() {
        if (!this.__Fconfiguration) {
            return this.configuration;
        }
        return (Configuration)this.__IM.onGet((Object)this, "configuration");
    }

    void __setconfiguration(Configuration configuration) {
        if (!this.__Fconfiguration) {
            this.configuration = configuration;
            return;
        }
        this.__IM.onSet((Object)this, "configuration", (Object)configuration);
    }

    Vertx __getvertx() {
        if (!this.__Fvertx) {
            return this.vertx;
        }
        return (Vertx)this.__IM.onGet((Object)this, "vertx");
    }

    void __setvertx(Vertx vertx) {
        if (!this.__Fvertx) {
            this.vertx = vertx;
            return;
        }
        this.__IM.onSet((Object)this, "vertx", (Object)vertx);
    }

    ServiceRegistration __getvertxRegistration() {
        if (!this.__FvertxRegistration) {
            return this.vertxRegistration;
        }
        return (ServiceRegistration)this.__IM.onGet((Object)this, "vertxRegistration");
    }

    void __setvertxRegistration(ServiceRegistration serviceRegistration) {
        if (!this.__FvertxRegistration) {
            this.vertxRegistration = serviceRegistration;
            return;
        }
        this.__IM.onSet((Object)this, "vertxRegistration", (Object)serviceRegistration);
    }

    ServiceRegistration __getbusRegistration() {
        if (!this.__FbusRegistration) {
            return this.busRegistration;
        }
        return (ServiceRegistration)this.__IM.onGet((Object)this, "busRegistration");
    }

    void __setbusRegistration(ServiceRegistration serviceRegistration) {
        if (!this.__FbusRegistration) {
            this.busRegistration = serviceRegistration;
            return;
        }
        this.__IM.onSet((Object)this, "busRegistration", (Object)serviceRegistration);
    }

    public VertxSingleton() {
        this(null);
    }

    private VertxSingleton(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public void start() {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Validate
    private void __M_start() {
        String cf;
        Integer threads;
        String coreThread;
        String log = System.getProperty("org.vertx.logger-delegate-factory-class-name");
        if (log == null) {
            System.setProperty("org.vertx.logger-delegate-factory-class-name", SLF4JLogDelegateFactory.class.getName());
        }
        if ((coreThread = System.getProperty("vertx.pool.eventloop.size")) == null && (threads = this.__getconfiguration().getInteger("pool.eventloop.size")) != null) {
            System.setProperty("vertx.pool.eventloop.size", threads.toString());
        }
        if ((cf = System.getProperty("vertx.clusterManagerFactory")) == null) {
            System.setProperty("vertx.clusterManagerFactory", HazelcastClusterManagerFactory.class.getName());
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            String hostname = this.__getconfiguration().get("cluster-host");
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            if (hostname != null) {
                Integer port = this.__getconfiguration().getIntegerWithDefault("cluster-port", Integer.valueOf(25500));
                String clusterConfig = this.__getconfiguration().getWithDefault("cluster-config", "conf/cluster.xml");
                System.setProperty("hazelcast.config", new File(clusterConfig).getAbsolutePath());
                this.__setvertx(new DefaultVertx(port, hostname, null));
                properties.put("eventbus.port", port);
                properties.put("eventbus.host", hostname);
            } else {
                this.__setvertx(new DefaultVertx());
            }
            this.__setvertxRegistration(this.__getcontext().registerService(Vertx.class, (Object)this.__getvertx(), properties));
            this.__setbusRegistration(this.__getcontext().registerService(EventBus.class, (Object)this.__getvertx().eventBus(), properties));
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __M_stop() {
        VertxSingleton.unregisterQuietly(this.__getvertxRegistration());
        VertxSingleton.unregisterQuietly(this.__getbusRegistration());
        this.__getvertx().stop();
        this.__setvertx(null);
    }

    private static void unregisterQuietly(ServiceRegistration reg) {
        if (reg != null) {
            try {
                reg.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("busRegistration")) {
                this.__FbusRegistration = true;
            }
            if (set.contains("configuration")) {
                this.__Fconfiguration = true;
            }
            if (set.contains("context")) {
                this.__Fcontext = true;
            }
            if (set.contains("vertx")) {
                this.__Fvertx = true;
            }
            if (set.contains("vertxRegistration")) {
                this.__FvertxRegistration = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

