/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.framework.vertx;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.ServerWebSocket;
import org.wisdom.framework.vertx.Server;
import org.wisdom.framework.vertx.ServiceAccessor;
import org.wisdom.framework.vertx.Socket;

public class WebSocketHandler
implements Handler<ServerWebSocket> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketHandler.class);
    private final ServiceAccessor accessor;
    private final Server configuration;

    public WebSocketHandler(ServiceAccessor accessor, Server server) {
        this.accessor = accessor;
        this.configuration = server;
    }

    @Override
    public void handle(final ServerWebSocket socket) {
        LOGGER.info("New web socket connection {}, {}", (Object)socket, (Object)socket.uri());
        if (!this.configuration.accept(socket.uri())) {
            LOGGER.warn("Web Socket connection denied on {} by {}", (Object)socket.uri(), (Object)this.configuration.name());
            return;
        }
        final Socket sock = new Socket(socket);
        this.accessor.getDispatcher().addSocket(socket.path(), sock);
        socket.closeHandler(new Handler<Void>(){

            @Override
            public void handle(Void event) {
                LOGGER.info("Web Socket closed {}, {}", (Object)socket, (Object)socket.uri());
                WebSocketHandler.this.accessor.getDispatcher().removeSocket(socket.path(), sock);
            }
        });
        socket.dataHandler(new Handler<Buffer>(){

            @Override
            public void handle(Buffer event) {
                WebSocketHandler.this.accessor.getDispatcher().received(socket.path(), event.getBytes(), sock);
            }
        });
    }
}

