/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.framework.vertx.cookies;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.api.configuration.ApplicationConfiguration;
import org.wisdom.api.cookies.Cookie;
import org.wisdom.api.cookies.FlashCookie;
import org.wisdom.api.http.Context;
import org.wisdom.api.http.Result;
import org.wisdom.api.utils.CookieDataCodec;

public class FlashCookieImpl
implements FlashCookie {
    public static final String FLASH_SUFFIX = "_FLASH";
    public static final String ERROR = "Encoding exception - this must not happen";
    private static final Logger LOGGER = LoggerFactory.getLogger(FlashCookieImpl.class);
    private Map<String, String> currentFlashCookieData = new HashMap<String, String>();
    private Map<String, String> outgoingFlashCookieData = new HashMap<String, String>();
    private final String applicationCookiePrefix;

    public FlashCookieImpl(ApplicationConfiguration configuration) {
        this.applicationCookiePrefix = configuration.getWithDefault("application.cookie.prefix", "wisdom");
    }

    public void init(Context context) {
        Cookie flashCookie = context.request().cookie(this.applicationCookiePrefix + FLASH_SUFFIX);
        if (flashCookie != null) {
            try {
                CookieDataCodec.decode(this.currentFlashCookieData, (String)flashCookie.value());
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error(ERROR, (Throwable)e);
            }
        }
    }

    public void save(Context context, Result result) {
        if (this.outgoingFlashCookieData.isEmpty()) {
            if (context.hasCookie(this.applicationCookiePrefix + FLASH_SUFFIX)) {
                Cookie.Builder cookie = Cookie.builder((String)(this.applicationCookiePrefix + FLASH_SUFFIX), (String)"");
                cookie.setPath("/");
                cookie.setSecure(false);
                cookie.setMaxAge(0L);
                result.with(cookie.build());
            }
        } else {
            try {
                String flashData = CookieDataCodec.encode(this.outgoingFlashCookieData);
                Cookie.Builder cookie = Cookie.builder((String)(this.applicationCookiePrefix + FLASH_SUFFIX), (String)flashData);
                cookie.setPath("/");
                cookie.setSecure(false);
                cookie.setMaxAge(3600L);
                result.with(cookie.build());
            }
            catch (Exception e) {
                LOGGER.error(ERROR, (Throwable)e);
            }
        }
    }

    public void put(String key, String value) {
        if (key.contains(":")) {
            throw new IllegalArgumentException("Character ':' is invalid in a flash key.");
        }
        this.currentFlashCookieData.put(key, value);
        this.outgoingFlashCookieData.put(key, value);
    }

    public void put(String key, Object value) {
        if (value == null) {
            this.put(key, null);
        } else {
            this.put(key, value);
        }
    }

    public void error(String value) {
        this.put("flash_error", value);
    }

    public void success(String value) {
        this.put("flash_success", value);
    }

    public void discard(String key) {
        this.outgoingFlashCookieData.remove(key);
    }

    public void discard() {
        this.outgoingFlashCookieData.clear();
    }

    public void keep(String key) {
        if (this.currentFlashCookieData.containsKey(key)) {
            this.outgoingFlashCookieData.put(key, this.currentFlashCookieData.get(key));
        }
    }

    public void keep() {
        this.outgoingFlashCookieData.putAll(this.currentFlashCookieData);
    }

    public String get(String key) {
        String value = this.currentFlashCookieData.get(key);
        if (value == null) {
            value = this.outgoingFlashCookieData.get(key);
        }
        return value;
    }

    public boolean remove(String key) {
        return this.currentFlashCookieData.remove(key) != null;
    }

    public void clearCurrentFlashCookieData() {
        this.currentFlashCookieData.clear();
    }

    public boolean contains(String key) {
        return this.currentFlashCookieData.containsKey(key);
    }

    public Map<String, String> getCurrentFlashCookieData() {
        return this.currentFlashCookieData;
    }

    public Map<String, String> getOutgoingFlashCookieData() {
        return this.outgoingFlashCookieData;
    }
}

