/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.framework.vertx.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.file.AsyncFile;
import org.vertx.java.core.http.HttpServerFileUpload;
import org.vertx.java.core.streams.Pump;
import org.wisdom.framework.vertx.file.VertxFileUpload;

public class DiskFileUpload
extends VertxFileUpload {
    public static final long MINSIZE = 16384L;
    public static boolean deleteOnExitTemporaryFile = true;
    public static String baseDirectory = null;
    public static final String prefix = "FUp_";
    private final File file;
    private AsyncFile async;
    private final Vertx vertx;

    public DiskFileUpload(Vertx vertx, HttpServerFileUpload upload) {
        super(upload);
        this.file = DiskFileUpload.tempFile(upload);
        this.vertx = vertx;
    }

    @Override
    public void cleanup() {
        FileUtils.deleteQuietly((File)this.file);
    }

    @Override
    public void push(final Buffer buffer) {
        if (this.async == null) {
            this.upload.pause();
            this.vertx.fileSystem().open(this.file.getAbsolutePath(), new Handler<AsyncResult<AsyncFile>>(){

                @Override
                public void handle(AsyncResult<AsyncFile> event) {
                    DiskFileUpload.this.async = event.result();
                    DiskFileUpload.this.async.exceptionHandler(new Handler<Throwable>(){

                        @Override
                        public void handle(Throwable event) {
                            LoggerFactory.getLogger((String)this.getClass().getName()).error("Cannot write into {}", (Object)DiskFileUpload.this.file.getAbsolutePath(), (Object)event);
                        }
                    });
                    DiskFileUpload.this.async.write(buffer);
                    Pump.createPump(DiskFileUpload.this.upload, DiskFileUpload.this.async).start();
                    DiskFileUpload.this.upload.resume();
                }
            });
        }
    }

    @Override
    public void close() {
        this.vertx.runOnContext(new Handler<Void>(){

            @Override
            public void handle(Void event) {
                DiskFileUpload.this.async.close();
            }
        });
    }

    static synchronized File tempFile(HttpServerFileUpload upload) {
        String diskFilename = new File(upload.filename()).getName();
        String newpostfix = '_' + diskFilename;
        try {
            File tmpFile = baseDirectory == null ? File.createTempFile(prefix, newpostfix) : File.createTempFile(prefix, newpostfix, new File(baseDirectory));
            if (deleteOnExitTemporaryFile) {
                tmpFile.deleteOnExit();
            }
            return tmpFile;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public byte[] bytes() {
        try {
            return FileUtils.readFileToByteArray((File)this.file);
        }
        catch (IOException e) {
            return null;
        }
    }

    public InputStream stream() {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public boolean isInMemory() {
        return false;
    }

    @Override
    public long size() {
        return this.file.length();
    }

    public File toFile() {
        return this.file;
    }
}

