/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.framework.vertx.file;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpServerFileUpload;
import org.wisdom.framework.vertx.file.VertxFileUpload;

public class MemoryFileUpload
extends VertxFileUpload {
    Buffer buffer = new Buffer();

    public MemoryFileUpload(HttpServerFileUpload upload) {
        super(upload);
    }

    @Override
    public void push(Buffer buffer) {
        this.buffer.appendBuffer(buffer);
    }

    @Override
    public void cleanup() {
        this.buffer = new Buffer(0);
    }

    public byte[] bytes() {
        return this.buffer.getBytes();
    }

    public InputStream stream() {
        return new ByteArrayInputStream(this.buffer.getBytes());
    }

    public boolean isInMemory() {
        return true;
    }

    public File toFile() throws IOException {
        File temp = File.createTempFile("wisdom-fup", this.name());
        FileUtils.writeByteArrayToFile((File)temp, (byte[])this.bytes());
        return temp;
    }
}

