/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.framework.vertx.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpServerFileUpload;
import org.wisdom.framework.vertx.file.DiskFileUpload;
import org.wisdom.framework.vertx.file.MemoryFileUpload;
import org.wisdom.framework.vertx.file.VertxFileUpload;

public class MixedFileUpload
extends VertxFileUpload {
    VertxFileUpload delegate;

    public MixedFileUpload(final Vertx vertx, final HttpServerFileUpload upload, final long limitSize, final long maxSize) {
        super(upload);
        this.delegate = new MemoryFileUpload(upload);
        ((HttpServerFileUpload)((HttpServerFileUpload)upload.exceptionHandler(new Handler<Throwable>(){

            @Override
            public void handle(Throwable event) {
                LoggerFactory.getLogger(MixedFileUpload.class).error("Cannot read the uploaded item {} ({})", new Object[]{upload.name(), upload.filename(), event});
            }
        })).endHandler(new Handler<Void>(){

            @Override
            public void handle(Void event) {
                MixedFileUpload.this.delegate.close();
            }
        })).dataHandler(new Handler<Buffer>(){

            @Override
            public void handle(Buffer event) {
                if (event != null && MixedFileUpload.this.delegate instanceof MemoryFileUpload) {
                    MemoryFileUpload mem = (MemoryFileUpload)MixedFileUpload.this.delegate;
                    MixedFileUpload.this.checkSize(mem.buffer.length() + event.length(), maxSize, upload);
                    if ((long)(mem.buffer.length() + event.length()) > limitSize) {
                        DiskFileUpload disk = new DiskFileUpload(vertx, upload);
                        disk.push(mem.buffer.appendBuffer(event));
                        MixedFileUpload.this.delegate = disk;
                    } else {
                        MixedFileUpload.this.delegate.push(event);
                    }
                }
            }
        });
    }

    private void checkSize(long newSize, long maxSize, HttpServerFileUpload upload) throws IllegalStateException {
        if (maxSize >= 0L && newSize > maxSize) {
            upload.dataHandler(null);
            this.error = "Size exceed allowed maximum capacity";
            throw new IllegalStateException("Size exceed allowed maximum capacity");
        }
    }

    @Override
    public void cleanup() {
        this.delegate.cleanup();
    }

    public byte[] bytes() {
        return this.delegate.bytes();
    }

    public InputStream stream() {
        return this.delegate.stream();
    }

    public boolean isInMemory() {
        return this.delegate.isInMemory();
    }

    public File toFile() throws IOException {
        return this.delegate.toFile();
    }
}

