/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.framework.vertx.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.KeyManagerFactory;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateIssuerName;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateSubjectName;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public final class FakeKeyStore {
    public static final String KEYSTORE_PATH = "conf/fake.keystore";
    public static final String DN_NAME = "CN=localhost, OU=Testing, O=Mavericks, L=Moon Base 1, ST=Cyberspace, C=CY";
    private static final String SHA1WITHRSA = "SHA1withRSA";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"wisdom-vertx-engine");
    public static final Pattern JAVA_VERSION = Pattern.compile("([0-9]*.[0-9]*)(.*)?");

    private FakeKeyStore() {
    }

    public static KeyManagerFactory keyManagerFactory(File root) {
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            File keyStoreFile = new File(root, KEYSTORE_PATH);
            if (!keyStoreFile.exists()) {
                FakeKeyStore.generateAndStoreKeyStore(keyStore, keyStoreFile);
            } else {
                FakeKeyStore.loadKeyStore(keyStore, keyStoreFile);
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(keyStore, "".toCharArray());
            return kmf;
        }
        catch (Exception e) {
            LOGGER.error("Cannot generate or read the fake key store", (Throwable)e);
            return null;
        }
    }

    private static void loadKeyStore(KeyStore keyStore, File keyStoreFile) throws IOException, NoSuchAlgorithmException, CertificateException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(keyStoreFile);
            keyStore.load(is, "".toCharArray());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateAndStoreKeyStore(KeyStore keyStore, File keyStoreFile) throws Exception {
        FileOutputStream out = null;
        try {
            LOGGER.info("Generating HTTPS key pair in " + keyStoreFile.getAbsolutePath() + " - this may take some" + " time. If nothing happens, try moving the mouse/typing on the keyboard to generate some entropy.");
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(1024);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            X509Certificate cert = FakeKeyStore.createSelfSignedCertificate(keyPair);
            keyStore.load(null, "".toCharArray());
            keyStore.setKeyEntry("wisdom-generated", keyPair.getPrivate(), "".toCharArray(), new X509Certificate[]{cert});
            keyStoreFile.getParentFile().mkdirs();
            out = new FileOutputStream(keyStoreFile);
            keyStore.store(out, "".toCharArray());
            LOGGER.info("Key Store generated in " + keyStoreFile.getAbsoluteFile());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    private static X509Certificate createSelfSignedCertificate(KeyPair keyPair) throws Exception {
        X509CertInfo certInfo = new X509CertInfo();
        certInfo.set("serialNumber", new CertificateSerialNumber(new BigInteger(64, new SecureRandom())));
        certInfo.set("version", new CertificateVersion(2));
        Date validFrom = new Date();
        Date validTo = new Date(validFrom.getTime() + 1576800000000L);
        CertificateValidity validity = new CertificateValidity(validFrom, validTo);
        certInfo.set("validity", validity);
        X500Name owner = new X500Name(DN_NAME);
        boolean justName = FakeKeyStore.isJavaAtLeast(1.8);
        if (justName) {
            certInfo.set("subject", owner);
            certInfo.set("issuer", owner);
        } else {
            certInfo.set("subject", new CertificateSubjectName(owner));
            certInfo.set("issuer", new CertificateIssuerName(owner));
        }
        certInfo.set("key", new CertificateX509Key(keyPair.getPublic()));
        AlgorithmId algorithm = new AlgorithmId(AlgorithmId.sha1WithRSAEncryption_oid);
        certInfo.set("algorithmID", new CertificateAlgorithmId(algorithm));
        X509CertImpl cert = new X509CertImpl(certInfo);
        cert.sign(keyPair.getPrivate(), SHA1WITHRSA);
        AlgorithmId actualAlgorithm = (AlgorithmId)cert.get("x509.algorithm");
        certInfo.set("algorithmID.algorithm", actualAlgorithm);
        X509CertImpl newCert = new X509CertImpl(certInfo);
        newCert.sign(keyPair.getPrivate(), SHA1WITHRSA);
        return newCert;
    }

    public static boolean isJavaAtLeast(double version) {
        String javaVersion = System.getProperty("java.version");
        if (javaVersion == null) {
            return false;
        }
        Matcher matcher = JAVA_VERSION.matcher(javaVersion);
        if (matcher.matches()) {
            javaVersion = matcher.group(1);
        }
        try {
            double v = Double.parseDouble(javaVersion);
            return v >= version;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

