/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.framework.vertx.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.framework.vertx.ServiceAccessor;
import org.wisdom.framework.vertx.ssl.AcceptAllTrustManager;
import org.wisdom.framework.vertx.ssl.FakeKeyStore;

public final class SSLServerContext {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"wisdom-vertx-engine");
    private static final String PROTOCOL = "TLS";
    private static SSLServerContext INSTANCE;
    private final SSLContext serverContext;
    private final ServiceAccessor accessor;
    private static final String HTTPSWARN = "HTTPS configured with no client side CA verification. Requires http://webid.info/ for client certificate verification.";
    private static final String HTTPSFAIL = "Failure during HTTPS initialization";

    private SSLServerContext(ServiceAccessor accessor) {
        KeyManagerFactory kmf;
        LOGGER.info("Configuring HTTPS support");
        this.accessor = accessor;
        File root = accessor.getConfiguration().getBaseDir();
        String path = accessor.getConfiguration().get("https.keyStore");
        String ca = accessor.getConfiguration().get("https.trustStore");
        TrustManager[] trusts = null;
        if (path == null) {
            kmf = this.getFakeKeyManagerFactory(root);
            LOGGER.warn(HTTPSWARN);
            trusts = new TrustManager[]{new AcceptAllTrustManager()};
        } else {
            try {
                kmf = this.getKeyManagerFactoryFromKeyStore(root, path);
            }
            catch (KeyStoreException e) {
                throw new RuntimeException("Cannot read the key store file", e);
            }
        }
        if (ca == null) {
            LOGGER.info("Using default trust store for client side CA verification");
        } else if ("noCA".equalsIgnoreCase(ca)) {
            trusts = new TrustManager[]{new AcceptAllTrustManager()};
            LOGGER.warn(HTTPSWARN);
        } else {
            try {
                trusts = this.getTrustManagerFactoryFromKeyStore(root, ca).getTrustManagers();
            }
            catch (KeyStoreException e) {
                throw new RuntimeException("Cannot read the trust store file", e);
            }
        }
        try {
            SSLContext context = SSLContext.getInstance(PROTOCOL);
            context.init(kmf.getKeyManagers(), trusts, null);
            this.serverContext = context;
        }
        catch (Exception e) {
            throw new RuntimeException(HTTPSFAIL + e.getMessage(), e);
        }
    }

    public static synchronized SSLServerContext getInstance(ServiceAccessor accessor) {
        if (INSTANCE == null) {
            INSTANCE = new SSLServerContext(accessor);
        }
        return INSTANCE;
    }

    public static synchronized void reset() {
        INSTANCE = null;
    }

    public SSLContext serverContext() {
        return this.serverContext;
    }

    private KeyManagerFactory getKeyManagerFactoryFromKeyStore(File maybeRoot, String path) throws KeyStoreException {
        KeyManagerFactory kmf;
        FileInputStream stream;
        block6: {
            File file;
            block5: {
                file = new File(path);
                if (!file.isFile()) {
                    file = new File(maybeRoot, path);
                }
                LOGGER.info("\t key store: " + file.getAbsolutePath());
                KeyStore keyStore = KeyStore.getInstance(this.accessor.getConfiguration().getWithDefault("https.keyStoreType", "JKS"));
                LOGGER.info("\t key store type: " + keyStore.getType());
                LOGGER.info("\t key store provider: " + keyStore.getProvider());
                char[] password = this.accessor.getConfiguration().getWithDefault("https.keyStorePassword", "").toCharArray();
                LOGGER.info("\t key store password length: " + password.length);
                String algorithm = this.accessor.getConfiguration().getWithDefault("https.keyStoreAlgorithm", KeyManagerFactory.getDefaultAlgorithm());
                LOGGER.info("\t key store algorithm: " + algorithm);
                if (!file.isFile()) break block5;
                stream = null;
                try {
                    stream = new FileInputStream(file);
                    keyStore.load(stream, password);
                    kmf = KeyManagerFactory.getInstance(algorithm);
                    kmf.init(keyStore, password);
                }
                catch (Exception e) {
                    try {
                        throw new RuntimeException(HTTPSFAIL + e.getMessage(), e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(stream);
                        throw throwable;
                    }
                }
                break block6;
            }
            throw new RuntimeException("Cannot load key store from '" + file.getAbsolutePath() + "', " + "the file does not exist");
        }
        IOUtils.closeQuietly((InputStream)stream);
        return kmf;
    }

    private KeyManagerFactory getFakeKeyManagerFactory(File root) {
        LOGGER.warn("Using generated key with self signed certificate for HTTPS. This MUST not be used in production. To  set the key store use: `-Dhttps.keyStore=my-keystore`");
        KeyManagerFactory kmf = FakeKeyStore.keyManagerFactory(root);
        return kmf;
    }

    private TrustManagerFactory getTrustManagerFactoryFromKeyStore(File maybeRoot, String path) throws KeyStoreException {
        TrustManagerFactory tmf;
        FileInputStream stream;
        block6: {
            File file;
            block5: {
                file = new File(path);
                if (!file.isFile()) {
                    file = new File(maybeRoot, path);
                }
                LOGGER.info("\t trust store: " + file.getAbsolutePath());
                KeyStore trustStore = KeyStore.getInstance(this.accessor.getConfiguration().getWithDefault("https.trustStoreType", "JKS"));
                LOGGER.info("\t trust store type: " + trustStore.getType());
                LOGGER.info("\t trust store provider: " + trustStore.getProvider());
                char[] password = this.accessor.getConfiguration().getWithDefault("https.trustStorePassword", "").toCharArray();
                LOGGER.info("\t trust store password length: " + password.length);
                String algorithm = this.accessor.getConfiguration().getWithDefault("https.trustStoreAlgorithm", KeyManagerFactory.getDefaultAlgorithm());
                LOGGER.info("\t trust store algorithm: " + algorithm);
                if (!file.isFile()) break block5;
                stream = null;
                try {
                    stream = new FileInputStream(file);
                    trustStore.load(stream, password);
                    tmf = TrustManagerFactory.getInstance(algorithm);
                    tmf.init(trustStore);
                }
                catch (Exception e) {
                    try {
                        throw new RuntimeException(HTTPSFAIL + e.getMessage(), e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(stream);
                        throw throwable;
                    }
                }
                break block6;
            }
            throw new RuntimeException("Cannot load trust store from '" + file.getAbsolutePath() + "', " + "the file does not exist");
        }
        IOUtils.closeQuietly((InputStream)stream);
        return tmf;
    }
}

