/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.executors;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.api.concurrent.CompositeExecutionContext;
import org.wisdom.api.concurrent.ExecutionContext;
import org.wisdom.api.concurrent.ExecutionContextService;
import org.wisdom.api.concurrent.ManagedExecutorService;
import org.wisdom.api.concurrent.ManagedFutureTask;
import org.wisdom.executors.Task;

public abstract class AbstractManagedExecutorService
implements ManagedExecutorService {
    protected final String name;
    protected final long hungTime;
    protected ListeningExecutorService executor;
    protected ThreadPoolExecutor internalPool;
    protected final Set<Task<?>> tasks = new LinkedHashSet();
    protected final Logger logger;
    protected ManagedExecutorService.ExecutionStatistics statistics = new ManagedExecutorService.ExecutionStatistics();
    protected List<ExecutionContextService> ecs;

    protected AbstractManagedExecutorService(String name, long hungTime, List<ExecutionContextService> ecs) {
        Preconditions.checkNotNull((Object)name);
        this.name = name;
        this.logger = LoggerFactory.getLogger((String)("executor-" + name));
        this.hungTime = hungTime;
        this.ecs = ecs;
    }

    protected AbstractManagedExecutorService setInternalPool(ThreadPoolExecutor executor) {
        this.internalPool = executor;
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)this.internalPool);
        return this;
    }

    protected ThreadPoolExecutor getInternalPool() {
        return this.internalPool;
    }

    protected ListeningExecutorService getExecutor() {
        return this.executor;
    }

    public String name() {
        return this.name;
    }

    public ManagedExecutorService.ExecutionStatistics getExecutionTimeStatistics() {
        return this.statistics.copy();
    }

    public Collection<ManagedFutureTask> getHungTasks() {
        ArrayList<ManagedFutureTask> hung = new ArrayList<ManagedFutureTask>();
        for (ManagedFutureTask managedFutureTask : this.tasks) {
            if (!managedFutureTask.isTaskHang()) continue;
            hung.add(managedFutureTask);
        }
        return hung;
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    public List<Runnable> shutdownNow() {
        for (Task<?> task : this.tasks) {
            task.cancel(true);
        }
        return this.executor.shutdownNow();
    }

    protected ExecutionContext createExecutionContext() {
        if (this.ecs == null) {
            return null;
        }
        ArrayList<ExecutionContextService> copy = new ArrayList<ExecutionContextService>(this.ecs);
        ArrayList<ExecutionContext> ec = new ArrayList<ExecutionContext>();
        for (ExecutionContextService svc : copy) {
            ec.add(svc.prepare());
        }
        return CompositeExecutionContext.create(ec);
    }

    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.awaitTermination(timeout, unit);
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        List futures = this.executor.invokeAll(tasks);
        ArrayList<Future<T>> manageable = new ArrayList<Future<T>>(futures.size());
        int i = 0;
        for (Callable<T> callable : tasks) {
            Task task = this.getNewTaskFor(callable);
            task.submitted((Future)futures.get(i));
            manageable.add(task);
            ++i;
        }
        return manageable;
    }

    protected abstract <T> Task getNewTaskFor(Callable<T> var1);

    protected abstract <V> Task<V> getNewTaskFor(Runnable var1, V var2);

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        List futures = this.executor.invokeAll(tasks, timeout, unit);
        ArrayList<Future<T>> manageable = new ArrayList<Future<T>>(futures.size());
        int i = 0;
        for (Callable<T> callable : tasks) {
            Task task = this.getNewTaskFor(callable);
            task.submitted((Future)futures.get(i));
            manageable.add(task);
            ++i;
        }
        return manageable;
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return (T)this.executor.invokeAny(tasks);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.executor.invokeAny(tasks, timeout, unit);
    }

    public void execute(Runnable command) {
        Task<Object> task = this.getNewTaskFor(command, null);
        task.execute();
    }

    public int getLargestPoolSize() {
        return this.internalPool.getLargestPoolSize();
    }

    public int getMaximumPoolSize() {
        return this.internalPool.getMaximumPoolSize();
    }

    public int getPoolSize() {
        return this.internalPool.getPoolSize();
    }

    public int getCorePoolSize() {
        return this.internalPool.getCorePoolSize();
    }

    public long getCompletedTaskCount() {
        return this.internalPool.getCompletedTaskCount();
    }

    public int getActiveCount() {
        return this.internalPool.getActiveCount();
    }

    public BlockingQueue<Runnable> getQueue() {
        return this.internalPool.getQueue();
    }

    public void purge() {
        this.internalPool.purge();
    }

    public boolean remove(Runnable task) {
        return this.internalPool.remove(task);
    }

    public long getTaskCount() {
        return this.internalPool.getTaskCount();
    }

    public long getKeepAliveTime(TimeUnit unit) {
        return this.internalPool.getKeepAliveTime(unit);
    }

    public <T> ManagedFutureTask<T> submit(Callable<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        return this.getNewTaskFor(task).execute();
    }

    public <T> ManagedFutureTask<T> submit(Runnable task, T result) {
        if (task == null) {
            throw new NullPointerException();
        }
        final Task<T> t = this.getNewTaskFor(task, result).execute();
        t.addListener(new Runnable(){

            @Override
            public void run() {
                AbstractManagedExecutorService.this.tasks.remove(t);
            }
        });
        this.tasks.add(t);
        return t;
    }

    public ManagedFutureTask<?> submit(Runnable task) {
        return this.submit(task, (T)null);
    }

    protected void addToStatistics(Task task) {
        this.statistics.accept(task.getTaskCompletionTime() - task.getTaskStartTime());
    }
}

