/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.executors;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Context;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.Validate;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.api.concurrent.ExecutionContextService;
import org.wisdom.api.concurrent.ManagedExecutorService;
import org.wisdom.api.concurrent.ManagedScheduledExecutorService;
import org.wisdom.api.configuration.ApplicationConfiguration;
import org.wisdom.api.configuration.Configuration;
import org.wisdom.executors.AbstractManagedExecutorService;
import org.wisdom.executors.ManagedExecutorServiceImpl;
import org.wisdom.executors.ManagedScheduledExecutorServiceImpl;

@Component
@Instantiate
public class Creator
implements Pojo {
    InstanceManager __IM;
    private static final Logger LOGGER = LoggerFactory.getLogger(Creator.class);
    private static final String[] EXPOSED_CLASSES_FOR_EXECUTORS = new String[]{ExecutorService.class.getName(), ManagedExecutorService.class.getName()};
    private static final String[] EXPOSED_CLASSES_FOR_SCHEDULERS = new String[]{ScheduledExecutorService.class.getName(), ManagedScheduledExecutorService.class.getName()};
    private boolean __Fconfiguration;
    @Requires
    ApplicationConfiguration configuration;
    private boolean __Fcontext;
    @Context
    BundleContext context;
    private boolean __Fecs;
    @Requires(specification=ExecutionContextService.class)
    List<ExecutionContextService> ecs;
    private boolean __Finstances;
    private final Map<ServiceRegistration, ExecutorService> instances;
    boolean __Mstart;
    boolean __McreateOtherExecutors$org_wisdom_api_configuration_Configuration;
    boolean __McreateOtherSchedulers$org_wisdom_api_configuration_Configuration;
    boolean __McreateExecutor$java_lang_String$org_wisdom_api_configuration_Configuration;
    boolean __McreateScheduler$java_lang_String$org_wisdom_api_configuration_Configuration;
    boolean __MgetPublishedProperties$org_wisdom_executors_AbstractManagedExecutorService;
    boolean __Mstop;

    ApplicationConfiguration __getconfiguration() {
        if (!this.__Fconfiguration) {
            return this.configuration;
        }
        return (ApplicationConfiguration)this.__IM.onGet((Object)this, "configuration");
    }

    void __setconfiguration(ApplicationConfiguration applicationConfiguration) {
        if (!this.__Fconfiguration) {
            this.configuration = applicationConfiguration;
            return;
        }
        this.__IM.onSet((Object)this, "configuration", (Object)applicationConfiguration);
    }

    BundleContext __getcontext() {
        if (!this.__Fcontext) {
            return this.context;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "context");
    }

    void __setcontext(BundleContext bundleContext) {
        if (!this.__Fcontext) {
            this.context = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "context", (Object)bundleContext);
    }

    List __getecs() {
        if (!this.__Fecs) {
            return this.ecs;
        }
        return (List)this.__IM.onGet((Object)this, "ecs");
    }

    void __setecs(List list) {
        if (!this.__Fecs) {
            this.ecs = list;
            return;
        }
        this.__IM.onSet((Object)this, "ecs", (Object)list);
    }

    Map __getinstances() {
        if (!this.__Finstances) {
            return this.instances;
        }
        return (Map)this.__IM.onGet((Object)this, "instances");
    }

    void __setinstances(Map map) {
        if (!this.__Finstances) {
            this.instances = map;
            return;
        }
        this.__IM.onSet((Object)this, "instances", (Object)map);
    }

    public Creator() {
        this(null);
    }

    private Creator(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setinstances(new HashMap());
    }

    public void start() {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __M_start() {
        Configuration conf = this.__getconfiguration().getConfiguration("pools");
        this.createExecutor("wisdom-system-executor", conf != null ? conf.getConfiguration("executors.wisdom-system-executor") : null);
        this.createScheduler("wisdom-system-scheduler", conf != null ? conf.getConfiguration("schedulers.wisdom-system-scheduler") : null);
        if (conf != null) {
            this.createOtherExecutors(conf.getConfiguration("executors"));
            this.createOtherSchedulers(conf.getConfiguration("schedulers"));
        }
    }

    private void createOtherExecutors(Configuration executors) {
        if (!this.__McreateOtherExecutors$org_wisdom_api_configuration_Configuration) {
            this.__M_createOtherExecutors(executors);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "createOtherExecutors$org_wisdom_api_configuration_Configuration", new Object[]{executors});
            this.__M_createOtherExecutors(executors);
            this.__IM.onExit((Object)this, "createOtherExecutors$org_wisdom_api_configuration_Configuration", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createOtherExecutors$org_wisdom_api_configuration_Configuration", throwable);
            throw throwable;
        }
    }

    private void __M_createOtherExecutors(Configuration executors) {
        if (executors == null) {
            return;
        }
        Set keys = executors.asMap().keySet();
        for (String key : keys) {
            if (key.equalsIgnoreCase("wisdom-system-executor")) continue;
            Configuration conf = executors.getConfiguration(key);
            this.createExecutor(key, conf);
        }
    }

    private void createOtherSchedulers(Configuration schedulers) {
        if (!this.__McreateOtherSchedulers$org_wisdom_api_configuration_Configuration) {
            this.__M_createOtherSchedulers(schedulers);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "createOtherSchedulers$org_wisdom_api_configuration_Configuration", new Object[]{schedulers});
            this.__M_createOtherSchedulers(schedulers);
            this.__IM.onExit((Object)this, "createOtherSchedulers$org_wisdom_api_configuration_Configuration", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createOtherSchedulers$org_wisdom_api_configuration_Configuration", throwable);
            throw throwable;
        }
    }

    private void __M_createOtherSchedulers(Configuration schedulers) {
        if (schedulers == null) {
            return;
        }
        Set keys = schedulers.asMap().keySet();
        for (String key : keys) {
            if (key.equalsIgnoreCase("wisdom-system-scheduler")) continue;
            Configuration conf = schedulers.getConfiguration(key);
            this.createScheduler(key, conf);
        }
    }

    private void createExecutor(String name, Configuration conf) {
        if (!this.__McreateExecutor$java_lang_String$org_wisdom_api_configuration_Configuration) {
            this.__M_createExecutor(name, conf);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "createExecutor$java_lang_String$org_wisdom_api_configuration_Configuration", new Object[]{name, conf});
            this.__M_createExecutor(name, conf);
            this.__IM.onExit((Object)this, "createExecutor$java_lang_String$org_wisdom_api_configuration_Configuration", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createExecutor$java_lang_String$org_wisdom_api_configuration_Configuration", throwable);
            throw throwable;
        }
    }

    private void __M_createExecutor(String name, Configuration conf) {
        LOGGER.info("Creating executor {}", (Object)name);
        ManagedExecutorServiceImpl executor = conf != null ? new ManagedExecutorServiceImpl("wisdom-system-executor", conf, (List<ExecutionContextService>)this.__getecs()) : new ManagedExecutorServiceImpl("wisdom-system-executor", ManagedExecutorService.ThreadType.POOLED, 60000L, 5, 25, 5000L, Integer.MAX_VALUE, 5, this.__getecs());
        ServiceRegistration reg = this.__getcontext().registerService(EXPOSED_CLASSES_FOR_EXECUTORS, (Object)executor, this.getPublishedProperties(executor));
        this.__getinstances().put(reg, executor);
    }

    private void createScheduler(String name, Configuration conf) {
        if (!this.__McreateScheduler$java_lang_String$org_wisdom_api_configuration_Configuration) {
            this.__M_createScheduler(name, conf);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "createScheduler$java_lang_String$org_wisdom_api_configuration_Configuration", new Object[]{name, conf});
            this.__M_createScheduler(name, conf);
            this.__IM.onExit((Object)this, "createScheduler$java_lang_String$org_wisdom_api_configuration_Configuration", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createScheduler$java_lang_String$org_wisdom_api_configuration_Configuration", throwable);
            throw throwable;
        }
    }

    private void __M_createScheduler(String name, Configuration conf) {
        LOGGER.info("Creating scheduler {}", (Object)name);
        ManagedScheduledExecutorServiceImpl executor = conf != null ? new ManagedScheduledExecutorServiceImpl(name, conf, (List<ExecutionContextService>)this.__getecs()) : new ManagedScheduledExecutorServiceImpl("wisdom-system-scheduler", ManagedExecutorService.ThreadType.POOLED, 60000L, 5, 5, this.__getecs());
        ServiceRegistration reg = this.__getcontext().registerService(EXPOSED_CLASSES_FOR_SCHEDULERS, (Object)executor, this.getPublishedProperties(executor));
        this.__getinstances().put(reg, executor);
    }

    private Dictionary<String, String> getPublishedProperties(AbstractManagedExecutorService executor) {
        Dictionary<String, String> dictionary;
        if (!this.__MgetPublishedProperties$org_wisdom_executors_AbstractManagedExecutorService) {
            return this.__M_getPublishedProperties(executor);
        }
        try {
            this.__IM.onEntry((Object)this, "getPublishedProperties$org_wisdom_executors_AbstractManagedExecutorService", new Object[]{executor});
            dictionary = this.__M_getPublishedProperties(executor);
            this.__IM.onExit((Object)this, "getPublishedProperties$org_wisdom_executors_AbstractManagedExecutorService", dictionary);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getPublishedProperties$org_wisdom_executors_AbstractManagedExecutorService", throwable);
            throw throwable;
        }
        return dictionary;
    }

    private Dictionary<String, String> __M_getPublishedProperties(AbstractManagedExecutorService executor) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("name", executor.name());
        return properties;
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __M_stop() {
        for (Map.Entry entry : this.__getinstances().entrySet()) {
            ((ServiceRegistration)entry.getKey()).unregister();
            ((ExecutorService)entry.getValue()).shutdownNow();
        }
        this.__getinstances().clear();
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("configuration")) {
                this.__Fconfiguration = true;
            }
            if (set.contains("context")) {
                this.__Fcontext = true;
            }
            if (set.contains("ecs")) {
                this.__Fecs = true;
            }
            if (set.contains("instances")) {
                this.__Finstances = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("createOtherExecutors$org_wisdom_api_configuration_Configuration")) {
                this.__McreateOtherExecutors$org_wisdom_api_configuration_Configuration = true;
            }
            if (set.contains("createOtherSchedulers$org_wisdom_api_configuration_Configuration")) {
                this.__McreateOtherSchedulers$org_wisdom_api_configuration_Configuration = true;
            }
            if (set.contains("createExecutor$java_lang_String$org_wisdom_api_configuration_Configuration")) {
                this.__McreateExecutor$java_lang_String$org_wisdom_api_configuration_Configuration = true;
            }
            if (set.contains("createScheduler$java_lang_String$org_wisdom_api_configuration_Configuration")) {
                this.__McreateScheduler$java_lang_String$org_wisdom_api_configuration_Configuration = true;
            }
            if (set.contains("getPublishedProperties$org_wisdom_executors_AbstractManagedExecutorService")) {
                this.__MgetPublishedProperties$org_wisdom_executors_AbstractManagedExecutorService = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

