/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.executors;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.wisdom.api.concurrent.ExecutionContextService;
import org.wisdom.api.concurrent.ManagedExecutorService;
import org.wisdom.api.configuration.Configuration;
import org.wisdom.executors.AbstractManagedExecutorService;
import org.wisdom.executors.Task;

public class ManagedExecutorServiceImpl
extends AbstractManagedExecutorService
implements ManagedExecutorService {
    public ManagedExecutorServiceImpl(String name, Configuration configuration, List<ExecutionContextService> ecs) {
        this(name, (ManagedExecutorService.ThreadType)configuration.get("threadType", ManagedExecutorService.ThreadType.class, (Object)ManagedExecutorService.ThreadType.POOLED), configuration.getDuration("hungTime", TimeUnit.MILLISECONDS, 60000L), configuration.getIntegerWithDefault("coreSize", Integer.valueOf(5)), configuration.getIntegerWithDefault("maxSize", Integer.valueOf(25)), configuration.getDuration("keepAlive", TimeUnit.MILLISECONDS, 5000L), configuration.getIntegerWithDefault("workQueueCapacity", Integer.valueOf(Integer.MAX_VALUE)), configuration.getIntegerWithDefault("priority", Integer.valueOf(5)), ecs);
    }

    public ManagedExecutorServiceImpl(String name, ManagedExecutorService.ThreadType tu, long hungTime, int coreSize, int maxSize, long keepAlive, int workQueueCapacity, int priority, List<ExecutionContextService> ecs) {
        super(name, hungTime, ecs);
        ThreadFactoryBuilder builder = new ThreadFactoryBuilder().setDaemon(tu == ManagedExecutorService.ThreadType.DAEMON).setNameFormat(name + "-%s").setPriority(priority).setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                ManagedExecutorServiceImpl.this.logger.error("Uncaught exception in thread '{}'", (Object)t.getName(), (Object)e);
            }
        });
        BlockingQueue<Runnable> queue = this.createWorkQueue(workQueueCapacity);
        this.setInternalPool(new ThreadPoolExecutor(coreSize, maxSize, keepAlive, TimeUnit.MILLISECONDS, queue, builder.build()));
    }

    protected BlockingQueue<Runnable> createWorkQueue(int workQueueCapacity) {
        if (workQueueCapacity < 0) {
            throw new IllegalArgumentException();
        }
        AbstractQueue queue = workQueueCapacity == Integer.MAX_VALUE ? new LinkedBlockingQueue<Runnable>() : (workQueueCapacity == 0 ? new SynchronousQueue() : new ArrayBlockingQueue(workQueueCapacity));
        return queue;
    }

    @Override
    protected <V> Task<V> getNewTaskFor(Runnable task, V result) {
        return new Task<V>(this.executor, task, result, this.createExecutionContext(), this.hungTime, this);
    }

    protected <V> Task<V> getNewTaskFor(Callable<V> callable) {
        return new Task<V>(this.executor, callable, this.createExecutionContext(), this.hungTime, this);
    }

    public void setExecutionContextService(ExecutionContextService ... services) {
        this.ecs = new ArrayList();
        Collections.addAll(this.ecs, services);
    }
}

