/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.executors;

import com.google.common.util.concurrent.JdkFutureAdapters;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.wisdom.api.concurrent.ManagedScheduledFutureTask;
import org.wisdom.executors.AbstractManagedExecutorService;
import org.wisdom.executors.Task;

public class ScheduledTask<V>
extends Task<V>
implements ManagedScheduledFutureTask<V>,
ScheduledFuture<V> {
    private final boolean periodic;
    private ScheduledFuture scheduledFuture;

    public ScheduledTask(ListeningExecutorService executor, Callable<V> callable, long hungTime, boolean periodic, AbstractManagedExecutorService parent) {
        super(executor, callable, null, hungTime, parent);
        this.periodic = periodic;
    }

    protected ScheduledTask(ListeningExecutorService executor, Runnable runnable, V result, long hungTime, boolean periodic, AbstractManagedExecutorService parent) {
        super(executor, runnable, result, null, hungTime, parent);
        this.periodic = periodic;
    }

    protected ScheduledTask<V> submittedScheduledTask(ScheduledFuture delegate) {
        this.submissionDate = System.currentTimeMillis();
        this.scheduledFuture = delegate;
        this.future = JdkFutureAdapters.listenInPoolThread((Future)delegate);
        return this;
    }

    public boolean isPeriodic() {
        return this.periodic;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return this.scheduledFuture.getDelay(unit);
    }

    @Override
    public int compareTo(Delayed o) {
        return this.scheduledFuture.compareTo(o);
    }

    public Runnable asRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    ScheduledTask.this.callable.call();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

