/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.executors;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.JdkFutureAdapters;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.wisdom.api.concurrent.ExecutionContext;
import org.wisdom.api.concurrent.ManagedFutureTask;
import org.wisdom.executors.AbstractManagedExecutorService;

public class Task<V>
extends FutureTask<V>
implements ListenableFuture<V>,
ManagedFutureTask<V> {
    private final ListeningExecutorService executor;
    private final ExecutionContext executionContext;
    protected final Callable<V> callable;
    protected ListenableFuture<V> future;
    private Throwable taskRunThrowable;
    private final AbstractManagedExecutorService parent;
    protected long submissionDate;
    private long startDate;
    private long completionDate;
    private long hungTime;

    protected Task(ListeningExecutorService executor, Runnable runnable, V result, ExecutionContext executionContext, long hungTime, AbstractManagedExecutorService parent) {
        super(runnable, result);
        this.callable = new EnhancedCallable(Executors.callable(runnable, result));
        this.executor = executor;
        this.executionContext = executionContext;
        this.hungTime = hungTime;
        this.parent = parent;
    }

    public Task(ListeningExecutorService executor, Callable<V> callable, ExecutionContext executionContext, long hungTime, AbstractManagedExecutorService parent) {
        super(callable);
        this.callable = new EnhancedCallable(callable);
        this.executor = executor;
        this.executionContext = executionContext;
        this.hungTime = hungTime;
        this.parent = parent;
    }

    protected Task<V> execute() {
        ListenableFuture future = this.executor.submit(this.callable);
        this.submitted((Future<V>)future);
        return this;
    }

    protected Task<V> submitted(Future<V> future) {
        this.submissionDate = System.currentTimeMillis();
        this.future = JdkFutureAdapters.listenInPoolThread(future);
        return this;
    }

    public void addListener(Runnable listener) {
        this.addListener(listener, (Executor)this.executor);
    }

    public void addListener(Runnable listener, Executor exec) {
        this.future.addListener(listener, exec);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.future != null && this.future.cancel(mayInterruptIfRunning);
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return (V)this.future.get();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        return (V)this.future.get(timeout, unit);
    }

    @Override
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    public Throwable cause() {
        return this.taskRunThrowable;
    }

    @Override
    protected void setException(Throwable throwable) {
        this.taskRunThrowable = throwable;
    }

    public Task onSuccess(final ManagedFutureTask.SuccessCallback<V> callback, Executor executor) {
        Futures.addCallback(this.future, (FutureCallback)new FutureCallback<V>(){

            public void onSuccess(V v) {
                callback.onSuccess((ManagedFutureTask)Task.this, v);
            }

            public void onFailure(Throwable throwable) {
            }
        }, (Executor)executor);
        return this;
    }

    public Task onSuccess(ManagedFutureTask.SuccessCallback<V> callback) {
        return this.onSuccess((ManagedFutureTask.SuccessCallback)callback, (Executor)this.executor);
    }

    public Task onFailure(final ManagedFutureTask.FailureCallback callback, Executor executor) {
        Futures.addCallback(this.future, (FutureCallback)new FutureCallback<V>(){

            public void onSuccess(V v) {
            }

            public void onFailure(Throwable throwable) {
                callback.onFailure((ManagedFutureTask)Task.this, throwable);
            }
        }, (Executor)executor);
        return this;
    }

    public Task onFailure(ManagedFutureTask.FailureCallback callback) {
        return this.onFailure(callback, (Executor)this.executor);
    }

    public boolean isTaskHang() {
        return this.completionDate == 0L && System.currentTimeMillis() - this.submissionDate >= this.hungTime;
    }

    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    public long getTaskStartTime() {
        return this.startDate;
    }

    public long getTaskCompletionTime() {
        return this.completionDate;
    }

    public long getTaskRunTime() {
        if (this.startDate == 0L) {
            return 0L;
        }
        if (this.completionDate == 0L) {
            return System.currentTimeMillis() - this.startDate;
        }
        return this.completionDate - this.startDate;
    }

    public long getHungTaskThreshold() {
        return this.hungTime;
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    class EnhancedCallable
    implements Callable<V> {
        private final Callable<V> delegate;

        private EnhancedCallable(Callable<V> delegate) {
            this.delegate = delegate;
        }

        @Override
        public V call() throws Exception {
            try {
                if (Task.this.executionContext != null) {
                    Task.this.executionContext.apply();
                }
                Task.this.startDate = System.currentTimeMillis();
                Object v = this.delegate.call();
                return v;
            }
            catch (Throwable e) {
                Task.this.setException(e);
                throw e;
            }
            finally {
                Task.this.completionDate = System.currentTimeMillis();
                if (Task.this.executionContext != null) {
                    Task.this.executionContext.unapply();
                }
                Task.this.parent.addToStatistics(Task.this);
            }
        }
    }
}

