/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.executors.context;

import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Provides;
import org.wisdom.api.concurrent.ExecutionContext;
import org.wisdom.api.concurrent.ExecutionContextService;

@Component
@Provides
@Instantiate
public class TCCLExecutionContextService
implements ExecutionContextService,
Pojo {
    InstanceManager __IM;
    public static final String TCCL_CONTEXT = "TCCL";
    boolean __Mname;
    boolean __Mprepare;

    public TCCLExecutionContextService() {
        this(null);
    }

    private TCCLExecutionContextService(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public String name() {
        String string;
        if (!this.__Mname) {
            return this.__M_name();
        }
        try {
            this.__IM.onEntry((Object)this, "name", new Object[0]);
            string = this.__M_name();
            this.__IM.onExit((Object)this, "name", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "name", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_name() {
        return TCCL_CONTEXT;
    }

    public ExecutionContext prepare() {
        ExecutionContext executionContext;
        if (!this.__Mprepare) {
            return this.__M_prepare();
        }
        try {
            this.__IM.onEntry((Object)this, "prepare", new Object[0]);
            executionContext = this.__M_prepare();
            this.__IM.onExit((Object)this, "prepare", (Object)executionContext);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "prepare", throwable);
            throw throwable;
        }
        return executionContext;
    }

    private ExecutionContext __M_prepare() {
        return new TCCLContextExecution();
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            // empty if block
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("name")) {
                this.__Mname = true;
            }
            if (set.contains("prepare")) {
                this.__Mprepare = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }

    private static class TCCLContextExecution
    implements ExecutionContext {
        private final ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        private ClassLoader current;

        public void apply() {
            if (this.tccl != null) {
                this.current = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.tccl);
            }
        }

        public void unapply() {
            if (this.tccl != null) {
                Thread.currentThread().setContextClassLoader(this.current);
            }
        }
    }
}

