/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.executors.scheduler;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Bind;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.Unbind;
import org.apache.felix.ipojo.annotations.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.api.annotations.scheduler.Every;
import org.wisdom.api.concurrent.ManagedScheduledExecutorService;
import org.wisdom.api.concurrent.ManagedScheduledFutureTask;
import org.wisdom.api.scheduler.Scheduled;
import org.wisdom.executors.scheduler.Job;

@Component(immediate=true)
@Instantiate
public class WisdomTaskScheduler
implements Pojo {
    InstanceManager __IM;
    private static final Logger LOGGER = LoggerFactory.getLogger(WisdomTaskScheduler.class);
    private boolean __Fscheduler;
    @Requires(filter="(name=wisdom-system-scheduler)", proxy=false)
    ManagedScheduledExecutorService scheduler;
    private boolean __Fjobs;
    List<Job> jobs;
    boolean __MbindScheduled$org_wisdom_api_scheduler_Scheduled;
    boolean __Minvalidate;
    boolean __Mvalidate;
    boolean __MunbindScheduled$org_wisdom_api_scheduler_Scheduled;

    ManagedScheduledExecutorService __getscheduler() {
        if (!this.__Fscheduler) {
            return this.scheduler;
        }
        return (ManagedScheduledExecutorService)this.__IM.onGet((Object)this, "scheduler");
    }

    void __setscheduler(ManagedScheduledExecutorService managedScheduledExecutorService) {
        if (!this.__Fscheduler) {
            this.scheduler = managedScheduledExecutorService;
            return;
        }
        this.__IM.onSet((Object)this, "scheduler", (Object)managedScheduledExecutorService);
    }

    List __getjobs() {
        if (!this.__Fjobs) {
            return this.jobs;
        }
        return (List)this.__IM.onGet((Object)this, "jobs");
    }

    void __setjobs(List list) {
        if (!this.__Fjobs) {
            this.jobs = list;
            return;
        }
        this.__IM.onSet((Object)this, "jobs", (Object)list);
    }

    public WisdomTaskScheduler() {
        this(null);
    }

    private WisdomTaskScheduler(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setjobs(new ArrayList());
    }

    protected static Logger getLogger() {
        return LOGGER;
    }

    public synchronized void bindScheduled(Scheduled scheduled) {
        if (!this.__MbindScheduled$org_wisdom_api_scheduler_Scheduled) {
            this.__M_bindScheduled(scheduled);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindScheduled$org_wisdom_api_scheduler_Scheduled", new Object[]{scheduled});
            this.__M_bindScheduled(scheduled);
            this.__IM.onExit((Object)this, "bindScheduled$org_wisdom_api_scheduler_Scheduled", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindScheduled$org_wisdom_api_scheduler_Scheduled", throwable);
            throw throwable;
        }
    }

    @Bind(aggregate=true, optional=true)
    private void __M_bindScheduled(Scheduled scheduled) {
        LOGGER.info("Scheduled service bound ({}) - analyzing jobs", (Object)scheduled);
        List<Job> extracted = WisdomTaskScheduler.extractJobsFromScheduled(scheduled);
        for (Job job : extracted) {
            LOGGER.info("Job extracted from {} : {}", (Object)scheduled, (Object)job.method().getName());
            ManagedScheduledFutureTask task = this.__getscheduler().scheduleAtFixedRate(job.function(), job.period(), job.period(), job.unit());
            job.submitted(task);
        }
        this.__getjobs().addAll(extracted);
    }

    public synchronized void invalidate() {
        if (!this.__Minvalidate) {
            this.__M_invalidate();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "invalidate", new Object[0]);
            this.__M_invalidate();
            this.__IM.onExit((Object)this, "invalidate", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "invalidate", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __M_invalidate() {
        for (Job job : this.__getjobs()) {
            LOGGER.info("Cancelling periodic task {}#{} on invalidation", (Object)job.scheduled().getClass().getName(), (Object)job.method().getName());
            job.task().cancel(true);
            job.submitted(null);
        }
    }

    public synchronized void validate() {
        if (!this.__Mvalidate) {
            this.__M_validate();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "validate", new Object[0]);
            this.__M_validate();
            this.__IM.onExit((Object)this, "validate", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "validate", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __M_validate() {
        for (Job job : this.__getjobs()) {
            if (job.task() != null) continue;
            ManagedScheduledFutureTask task = this.__getscheduler().scheduleAtFixedRate(job.function(), job.period(), job.period(), job.unit());
            job.submitted(task);
        }
    }

    public synchronized void unbindScheduled(Scheduled scheduled) {
        if (!this.__MunbindScheduled$org_wisdom_api_scheduler_Scheduled) {
            this.__M_unbindScheduled(scheduled);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindScheduled$org_wisdom_api_scheduler_Scheduled", new Object[]{scheduled});
            this.__M_unbindScheduled(scheduled);
            this.__IM.onExit((Object)this, "unbindScheduled$org_wisdom_api_scheduler_Scheduled", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindScheduled$org_wisdom_api_scheduler_Scheduled", throwable);
            throw throwable;
        }
    }

    @Unbind
    private void __M_unbindScheduled(Scheduled scheduled) {
        for (Job job : this.__getjobs().toArray(new Job[this.__getjobs().size()])) {
            if (!job.scheduled().equals(scheduled)) continue;
            LOGGER.info("Cancelling periodic task {}#{}", (Object)job.scheduled().getClass().getName(), (Object)job.method().getName());
            job.task().cancel(true);
            this.__getjobs().remove(job);
        }
    }

    public static List<Job> extractJobsFromScheduled(Scheduled scheduled) {
        Method[] methods = scheduled.getClass().getMethods();
        ArrayList<Job> listOfJobs = new ArrayList<Job>();
        for (Method method : methods) {
            Every every = method.getAnnotation(Every.class);
            if (every == null) continue;
            try {
                listOfJobs.add(new Job(scheduled, method, every));
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Cannot parse the period '{}' from scheduled method {}.{}", new Object[]{every.value(), scheduled.getClass().getName(), method.getName(), e});
            }
        }
        return listOfJobs;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("jobs")) {
                this.__Fjobs = true;
            }
            if (set.contains("scheduler")) {
                this.__Fscheduler = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("bindScheduled$org_wisdom_api_scheduler_Scheduled")) {
                this.__MbindScheduled$org_wisdom_api_scheduler_Scheduled = true;
            }
            if (set.contains("invalidate")) {
                this.__Minvalidate = true;
            }
            if (set.contains("validate")) {
                this.__Mvalidate = true;
            }
            if (set.contains("unbindScheduled$org_wisdom_api_scheduler_Scheduled")) {
                this.__MunbindScheduled$org_wisdom_api_scheduler_Scheduled = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

