/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.i18n;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Requires;
import org.wisdom.api.DefaultController;
import org.wisdom.api.annotations.Controller;
import org.wisdom.api.annotations.HttpParameter;
import org.wisdom.api.annotations.Parameter;
import org.wisdom.api.annotations.PathParameter;
import org.wisdom.api.annotations.QueryParameter;
import org.wisdom.api.annotations.Route;
import org.wisdom.api.content.Json;
import org.wisdom.api.http.HttpMethod;
import org.wisdom.api.http.Result;
import org.wisdom.api.i18n.InternationalizationService;

@Controller
public class I18nController
extends DefaultController
implements Pojo {
    InstanceManager __IM;
    private boolean __Fservice;
    @Requires
    InternationalizationService service;
    private boolean __Fjson;
    @Requires
    Json json;
    boolean __MgetBundleResource$java_lang_String$java_lang_String;
    boolean __MgetBundleResourceForI18Next$java_lang_String$java_lang_String;
    boolean __MpopulateJsonResourceBundle$com_fasterxml_jackson_databind_node_ObjectNode$java_lang_String$java_lang_String;
    boolean __MgetMessage$java_lang_String$java_util_Locale;
    boolean __MgetMessages$java_util_List$java_lang_String;

    InternationalizationService __getservice() {
        if (!this.__Fservice) {
            return this.service;
        }
        return (InternationalizationService)this.__IM.onGet((Object)this, "service");
    }

    void __setservice(InternationalizationService internationalizationService) {
        if (!this.__Fservice) {
            this.service = internationalizationService;
            return;
        }
        this.__IM.onSet((Object)this, "service", (Object)internationalizationService);
    }

    Json __getjson() {
        if (!this.__Fjson) {
            return this.json;
        }
        return (Json)this.__IM.onGet((Object)this, "json");
    }

    void __setjson(Json json) {
        if (!this.__Fjson) {
            this.json = json;
            return;
        }
        this.__IM.onSet((Object)this, "json", (Object)json);
    }

    public I18nController() {
        this(null);
    }

    private I18nController(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    @Route(uri="i18n/bundles/{file<.+>}.properties", method=HttpMethod.GET)
    public Result getBundleResource(@PathParameter(value="file") String file, @HttpParameter(value="If-None-Match") String ifNoneMatch) {
        Result result;
        if (!this.__MgetBundleResource$java_lang_String$java_lang_String) {
            return this.__M_getBundleResource(file, ifNoneMatch);
        }
        try {
            this.__IM.onEntry((Object)this, "getBundleResource$java_lang_String$java_lang_String", new Object[]{file, ifNoneMatch});
            result = this.__M_getBundleResource(file, ifNoneMatch);
            this.__IM.onExit((Object)this, "getBundleResource$java_lang_String$java_lang_String", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getBundleResource$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_getBundleResource(String file, String ifNoneMatch) {
        if (Strings.isNullOrEmpty((String)file)) {
            return I18nController.notFound().as("text/plain");
        }
        Locale locale = InternationalizationService.DEFAULT_LOCALE;
        if (file.contains("_")) {
            locale = Locale.forLanguageTag(file.substring(file.indexOf(95) + 1).replace("_", "-"));
        }
        String etag = this.__getservice().etag(locale);
        if (ifNoneMatch != null && ifNoneMatch.equals(etag)) {
            return new Result(304);
        }
        Collection bundles = this.__getservice().bundles(locale);
        if (bundles.isEmpty()) {
            return I18nController.notFound().as("text/plain");
        }
        StringBuilder builder = new StringBuilder();
        for (ResourceBundle bundle : bundles) {
            for (String key : bundle.keySet()) {
                builder.append(key).append("=").append(bundle.getString(key)).append("\n");
            }
        }
        return I18nController.ok((String)builder.toString()).as("text/plain").with("Etag", etag);
    }

    @Route(uri="i18n/bundles/{file<.+>}.json", method=HttpMethod.GET)
    public Result getBundleResourceForI18Next(@QueryParameter(value="locales") String listOfLocales, @HttpParameter(value="If-None-Match") String ifNoneMatch) {
        Result result;
        if (!this.__MgetBundleResourceForI18Next$java_lang_String$java_lang_String) {
            return this.__M_getBundleResourceForI18Next(listOfLocales, ifNoneMatch);
        }
        try {
            this.__IM.onEntry((Object)this, "getBundleResourceForI18Next$java_lang_String$java_lang_String", new Object[]{listOfLocales, ifNoneMatch});
            result = this.__M_getBundleResourceForI18Next(listOfLocales, ifNoneMatch);
            this.__IM.onExit((Object)this, "getBundleResourceForI18Next$java_lang_String$java_lang_String", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getBundleResourceForI18Next$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_getBundleResourceForI18Next(String listOfLocales, String ifNoneMatch) {
        ArrayList<Locale> locales = new ArrayList<Locale>();
        if (!Strings.isNullOrEmpty((String)listOfLocales)) {
            String[] items;
            for (String item : items = listOfLocales.split(" ")) {
                if ("dev".equalsIgnoreCase(item)) {
                    locales.add(InternationalizationService.DEFAULT_LOCALE);
                    continue;
                }
                locales.add(Locale.forLanguageTag(item));
            }
        }
        StringBuilder builder = new StringBuilder();
        for (Locale locale : locales) {
            builder.append(this.__getservice().etag(locale));
        }
        String etag = builder.toString();
        if (ifNoneMatch != null && ifNoneMatch.equals(etag)) {
            return new Result(304);
        }
        ObjectNode result = this.__getjson().newObject();
        for (Locale locale : locales) {
            ObjectNode lang = this.__getjson().newObject();
            ObjectNode translation = this.__getjson().newObject();
            lang.set("translation", (JsonNode)translation);
            Collection bundles = this.__getservice().bundles(locale);
            for (ResourceBundle bundle : bundles) {
                for (String key : bundle.keySet()) {
                    this.populateJsonResourceBundle(translation, key, bundle.getString(key));
                }
            }
            String langName = locale.toLanguageTag();
            if (locale.equals(InternationalizationService.DEFAULT_LOCALE)) {
                langName = "dev";
            }
            result.set(langName, (JsonNode)lang);
        }
        return I18nController.ok((JsonNode)result).with("Etag", etag);
    }

    private void populateJsonResourceBundle(ObjectNode node, String key, String value) {
        if (!this.__MpopulateJsonResourceBundle$com_fasterxml_jackson_databind_node_ObjectNode$java_lang_String$java_lang_String) {
            this.__M_populateJsonResourceBundle(node, key, value);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "populateJsonResourceBundle$com_fasterxml_jackson_databind_node_ObjectNode$java_lang_String$java_lang_String", new Object[]{node, key, value});
            this.__M_populateJsonResourceBundle(node, key, value);
            this.__IM.onExit((Object)this, "populateJsonResourceBundle$com_fasterxml_jackson_databind_node_ObjectNode$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "populateJsonResourceBundle$com_fasterxml_jackson_databind_node_ObjectNode$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_populateJsonResourceBundle(ObjectNode node, String key, String value) {
        int indexOfDot = key.indexOf(46);
        if (indexOfDot != -1) {
            String prefix = key.substring(0, indexOfDot);
            String remainder = key.substring(indexOfDot + 1);
            JsonNode subNode = node.get(prefix);
            if (subNode == null) {
                subNode = this.__getjson().newObject();
                node.set(prefix, subNode);
            } else if (!subNode.isObject()) {
                throw new IllegalStateException("Invalid JSON Resource Bundle format, the key " + prefix + " is " + "already present and is not an Object Node");
            }
            this.populateJsonResourceBundle((ObjectNode)subNode, remainder, value);
        } else {
            node.put(key, value);
        }
    }

    @Route(uri="i18n/{key}", method=HttpMethod.GET)
    public Result getMessage(@Parameter(value="key") String key, @QueryParameter(value="locale") Locale locale) {
        Result result;
        if (!this.__MgetMessage$java_lang_String$java_util_Locale) {
            return this.__M_getMessage(key, locale);
        }
        try {
            this.__IM.onEntry((Object)this, "getMessage$java_lang_String$java_util_Locale", new Object[]{key, locale});
            result = this.__M_getMessage(key, locale);
            this.__IM.onExit((Object)this, "getMessage$java_lang_String$java_util_Locale", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getMessage$java_lang_String$java_util_Locale", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_getMessage(String key, Locale locale) {
        String message = locale != null && !locale.equals(InternationalizationService.DEFAULT_LOCALE) ? this.__getservice().get(locale, key, new Object[0]) : this.__getservice().get(this.context().request().languages(), key, new Object[0]);
        if (message != null) {
            return I18nController.ok((String)message).as("text/plain");
        }
        return I18nController.notFound((String)("No message for " + key)).as("text/plain");
    }

    @Route(uri="i18n", method=HttpMethod.GET)
    public Result getMessages(@QueryParameter(value="locales") List<Locale> locales, @HttpParameter(value="If-None-Match") String ifNoneMatch) {
        Result result;
        if (!this.__MgetMessages$java_util_List$java_lang_String) {
            return this.__M_getMessages(locales, ifNoneMatch);
        }
        try {
            this.__IM.onEntry((Object)this, "getMessages$java_util_List$java_lang_String", new Object[]{locales, ifNoneMatch});
            result = this.__M_getMessages(locales, ifNoneMatch);
            this.__IM.onExit((Object)this, "getMessages$java_util_List$java_lang_String", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getMessages$java_util_List$java_lang_String", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_getMessages(List<Locale> locales, String ifNoneMatch) {
        StringBuilder builder = new StringBuilder();
        if (locales != null && !locales.isEmpty()) {
            for (Locale locale : locales) {
                builder.append(this.__getservice().etag(locale));
            }
        } else {
            for (Locale locale : this.context().request().languages()) {
                builder.append(this.__getservice().etag(locale));
            }
        }
        String etag = builder.toString();
        if (ifNoneMatch != null && ifNoneMatch.equals(etag)) {
            return new Result(304);
        }
        Map messages = locales != null && !locales.isEmpty() ? this.__getservice().getAllMessages(locales.toArray(new Locale[locales.size()])) : this.__getservice().getAllMessages(this.context().request().languages());
        if (messages != null) {
            return I18nController.ok((Object)messages).with("Etag", etag).json();
        }
        return I18nController.notFound().json();
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("json")) {
                this.__Fjson = true;
            }
            if (set.contains("service")) {
                this.__Fservice = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("getBundleResource$java_lang_String$java_lang_String")) {
                this.__MgetBundleResource$java_lang_String$java_lang_String = true;
            }
            if (set.contains("getBundleResourceForI18Next$java_lang_String$java_lang_String")) {
                this.__MgetBundleResourceForI18Next$java_lang_String$java_lang_String = true;
            }
            if (set.contains("populateJsonResourceBundle$com_fasterxml_jackson_databind_node_ObjectNode$java_lang_String$java_lang_String")) {
                this.__MpopulateJsonResourceBundle$com_fasterxml_jackson_databind_node_ObjectNode$java_lang_String$java_lang_String = true;
            }
            if (set.contains("getMessage$java_lang_String$java_util_Locale")) {
                this.__MgetMessage$java_lang_String$java_util_Locale = true;
            }
            if (set.contains("getMessages$java_util_List$java_lang_String")) {
                this.__MgetMessages$java_util_List$java_lang_String = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

