/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.i18n;

import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.wisdom.i18n.UTF8PropertiesResourceBundle;
import org.wisdom.i18n.XMLResourceBundle;

public class I18nExtension {
    private ResourceBundle bundle;
    private final URL resource;
    private final Locale locale;
    private final Bundle source;

    public I18nExtension(URL resource, Locale locale, Bundle source) {
        this.resource = resource;
        this.locale = locale;
        this.source = source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        I18nExtension extension = (I18nExtension)o;
        return this.locale.equals(extension.locale) && this.resource.toExternalForm().equals(extension.resource.toExternalForm());
    }

    public int hashCode() {
        int result = this.resource.toExternalForm().hashCode();
        result = 31 * result + this.locale.hashCode();
        return result;
    }

    public void load() throws IOException {
        this.bundle = this.resource.toExternalForm().endsWith(".xml") ? new XMLResourceBundle(this.resource.openStream()) : new UTF8PropertiesResourceBundle(this.resource.openStream());
        if (this.bundle.keySet().isEmpty()) {
            throw new IOException(this.resource.toExternalForm() + " is not a valid resource - no keys");
        }
    }

    public String get(String key, Object ... args) {
        String value = this.bundle.getString(key);
        if (args.length != 0) {
            value = MessageFormat.format(value, args);
        }
        return value;
    }

    public Set<String> keys() {
        LinkedHashSet<String> list = new LinkedHashSet<String>();
        Enumeration<String> keys = this.bundle.getKeys();
        while (keys.hasMoreElements()) {
            list.add(keys.nextElement());
        }
        return list;
    }

    public Locale locale() {
        return this.locale;
    }

    public ResourceBundle bundle() {
        return this.bundle;
    }

    public Bundle source() {
        return this.source;
    }

    public Map<String, String> map() {
        HashMap<String, String> messages = new HashMap<String, String>();
        for (String k : this.bundle.keySet()) {
            messages.put(k, this.get(k, new Object[0]));
        }
        return messages;
    }
}

