/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.i18n;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.Validate;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.api.configuration.ApplicationConfiguration;
import org.wisdom.api.i18n.InternationalizationService;
import org.wisdom.i18n.ExtenderUtils;
import org.wisdom.i18n.I18nExtension;

@Component
@Provides(specifications={InternationalizationService.class})
@Instantiate
public class InternationalizationServiceSingleton
implements InternationalizationService,
BundleTrackerCustomizer<List<I18nExtension>> {
    InstanceManager __IM;
    private static final Logger LOGGER = LoggerFactory.getLogger(InternationalizationService.class);
    private boolean __Fcontext;
    private final BundleContext context;
    private boolean __FdefaultLocale;
    private final Locale defaultLocale;
    private boolean __Fconfiguration;
    @Requires
    ApplicationConfiguration configuration;
    private boolean __Fextensions;
    private List<I18nExtension> extensions;
    private boolean __Ftracker;
    private BundleTracker<List<I18nExtension>> tracker;
    private boolean __Fetags;
    private Map<Locale, String> etags;
    boolean __MgetDefaultLocale;
    boolean __Mstart;
    boolean __Mstop;
    boolean __MdefaultLocale;
    boolean __Mbundles;
    boolean __Mbundles$java_util_Locale;
    boolean __Mget$java_util_Locale__$java_lang_String$java_lang_Object__;
    boolean __Mget$java_util_Locale$java_lang_String$java_lang_Object__;
    boolean __MgetAllMessages$java_util_Locale;
    boolean __MgetAllMessages$java_util_Locale__;
    boolean __Metag$java_util_Locale;
    boolean __Mmerge$java_util_Map$java_util_Map;
    boolean __MgetExtension$java_util_Locale;
    boolean __MgetExtension$java_util_Locale$java_lang_String;
    boolean __MaddingBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent;
    boolean __MmodifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List;
    boolean __MremovedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List;
    boolean __MremovedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_lang_Object;
    boolean __MmodifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_lang_Object;

    BundleContext __getcontext() {
        if (!this.__Fcontext) {
            return this.context;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "context");
    }

    void __setcontext(BundleContext bundleContext) {
        if (!this.__Fcontext) {
            this.context = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "context", (Object)bundleContext);
    }

    Locale __getdefaultLocale() {
        if (!this.__FdefaultLocale) {
            return this.defaultLocale;
        }
        return (Locale)this.__IM.onGet((Object)this, "defaultLocale");
    }

    void __setdefaultLocale(Locale locale) {
        if (!this.__FdefaultLocale) {
            this.defaultLocale = locale;
            return;
        }
        this.__IM.onSet((Object)this, "defaultLocale", (Object)locale);
    }

    ApplicationConfiguration __getconfiguration() {
        if (!this.__Fconfiguration) {
            return this.configuration;
        }
        return (ApplicationConfiguration)this.__IM.onGet((Object)this, "configuration");
    }

    void __setconfiguration(ApplicationConfiguration applicationConfiguration) {
        if (!this.__Fconfiguration) {
            this.configuration = applicationConfiguration;
            return;
        }
        this.__IM.onSet((Object)this, "configuration", (Object)applicationConfiguration);
    }

    List __getextensions() {
        if (!this.__Fextensions) {
            return this.extensions;
        }
        return (List)this.__IM.onGet((Object)this, "extensions");
    }

    void __setextensions(List list) {
        if (!this.__Fextensions) {
            this.extensions = list;
            return;
        }
        this.__IM.onSet((Object)this, "extensions", (Object)list);
    }

    BundleTracker __gettracker() {
        if (!this.__Ftracker) {
            return this.tracker;
        }
        return (BundleTracker)this.__IM.onGet((Object)this, "tracker");
    }

    void __settracker(BundleTracker bundleTracker) {
        if (!this.__Ftracker) {
            this.tracker = bundleTracker;
            return;
        }
        this.__IM.onSet((Object)this, "tracker", (Object)bundleTracker);
    }

    Map __getetags() {
        if (!this.__Fetags) {
            return this.etags;
        }
        return (Map)this.__IM.onGet((Object)this, "etags");
    }

    void __setetags(Map map) {
        if (!this.__Fetags) {
            this.etags = map;
            return;
        }
        this.__IM.onSet((Object)this, "etags", (Object)map);
    }

    public InternationalizationServiceSingleton(BundleContext context) {
        this(null, context);
    }

    private InternationalizationServiceSingleton(InstanceManager _manager, BundleContext context) {
        this._setInstanceManager(_manager);
        this.__setextensions(new ArrayList());
        this.__setetags(new HashMap());
        this.__setcontext(context);
        if (this.__getconfiguration() != null) {
            this.__setdefaultLocale(Locale.forLanguageTag(this.getDefaultLocale()));
        } else {
            this.__setdefaultLocale(null);
        }
    }

    protected String getDefaultLocale() {
        String string;
        if (!this.__MgetDefaultLocale) {
            return this.__M_getDefaultLocale();
        }
        try {
            this.__IM.onEntry((Object)this, "getDefaultLocale", new Object[0]);
            string = this.__M_getDefaultLocale();
            this.__IM.onExit((Object)this, "getDefaultLocale", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDefaultLocale", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getDefaultLocale() {
        return this.__getconfiguration().getWithDefault("application.locale", this.__getconfiguration().getWithDefault("application.default.locale", Locale.ENGLISH.toLanguageTag()));
    }

    public void start() {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __M_start() {
        this.__settracker(new BundleTracker(this.__getcontext(), 32, (BundleTrackerCustomizer)this));
        this.__gettracker().open();
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __M_stop() {
        if (this.__gettracker() != null) {
            this.__gettracker().close();
        }
        this.__getextensions().clear();
    }

    public Locale defaultLocale() {
        Locale locale;
        if (!this.__MdefaultLocale) {
            return this.__M_defaultLocale();
        }
        try {
            this.__IM.onEntry((Object)this, "defaultLocale", new Object[0]);
            locale = this.__M_defaultLocale();
            this.__IM.onExit((Object)this, "defaultLocale", (Object)locale);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "defaultLocale", throwable);
            throw throwable;
        }
        return locale;
    }

    private Locale __M_defaultLocale() {
        if (this.__getdefaultLocale() == null) {
            return InternationalizationService.DEFAULT_LOCALE;
        }
        return this.__getdefaultLocale();
    }

    public Collection<ResourceBundle> bundles() {
        Collection<ResourceBundle> collection;
        if (!this.__Mbundles) {
            return this.__M_bundles();
        }
        try {
            this.__IM.onEntry((Object)this, "bundles", new Object[0]);
            collection = this.__M_bundles();
            this.__IM.onExit((Object)this, "bundles", collection);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bundles", throwable);
            throw throwable;
        }
        return collection;
    }

    private Collection<ResourceBundle> __M_bundles() {
        LinkedHashSet<ResourceBundle> bundles = new LinkedHashSet<ResourceBundle>();
        for (I18nExtension extension : this.__getextensions()) {
            bundles.add(extension.bundle());
        }
        return bundles;
    }

    public Collection<ResourceBundle> bundles(Locale locale) {
        Collection<ResourceBundle> collection;
        if (!this.__Mbundles$java_util_Locale) {
            return this.__M_bundles(locale);
        }
        try {
            this.__IM.onEntry((Object)this, "bundles$java_util_Locale", new Object[]{locale});
            collection = this.__M_bundles(locale);
            this.__IM.onExit((Object)this, "bundles$java_util_Locale", collection);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bundles$java_util_Locale", throwable);
            throw throwable;
        }
        return collection;
    }

    private Collection<ResourceBundle> __M_bundles(Locale locale) {
        LinkedHashSet<ResourceBundle> bundles = new LinkedHashSet<ResourceBundle>();
        for (I18nExtension extension : this.__getextensions()) {
            if (!extension.locale().equals(locale)) continue;
            bundles.add(extension.bundle());
        }
        return bundles;
    }

    public String get(Locale[] locales, String key, Object ... args) {
        String string;
        if (!this.__Mget$java_util_Locale__$java_lang_String$java_lang_Object__) {
            return this.__M_get(locales, key, args);
        }
        try {
            this.__IM.onEntry((Object)this, "get$java_util_Locale__$java_lang_String$java_lang_Object__", new Object[]{locales, key, args});
            string = this.__M_get(locales, key, args);
            this.__IM.onExit((Object)this, "get$java_util_Locale__$java_lang_String$java_lang_Object__", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "get$java_util_Locale__$java_lang_String$java_lang_Object__", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_get(Locale[] locales, String key, Object[] args) {
        for (Locale locale : locales) {
            I18nExtension extension = this.getExtension(locale, key);
            if (extension == null) continue;
            return extension.get(key, args);
        }
        I18nExtension extension = this.getExtension(InternationalizationService.DEFAULT_LOCALE, key);
        if (extension != null) {
            return extension.get(key, args);
        }
        return null;
    }

    public String get(Locale locale, String key, Object ... args) {
        String string;
        if (!this.__Mget$java_util_Locale$java_lang_String$java_lang_Object__) {
            return this.__M_get(locale, key, args);
        }
        try {
            this.__IM.onEntry((Object)this, "get$java_util_Locale$java_lang_String$java_lang_Object__", new Object[]{locale, key, args});
            string = this.__M_get(locale, key, args);
            this.__IM.onExit((Object)this, "get$java_util_Locale$java_lang_String$java_lang_Object__", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "get$java_util_Locale$java_lang_String$java_lang_Object__", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_get(Locale locale, String key, Object[] args) {
        I18nExtension extension = this.getExtension(locale, key);
        if (extension != null) {
            return extension.get(key, args);
        }
        extension = this.getExtension(InternationalizationService.DEFAULT_LOCALE, key);
        if (extension != null) {
            return extension.get(key, args);
        }
        return null;
    }

    public Map<String, String> getAllMessages(Locale locale) {
        Map<String, String> map;
        if (!this.__MgetAllMessages$java_util_Locale) {
            return this.__M_getAllMessages(locale);
        }
        try {
            this.__IM.onEntry((Object)this, "getAllMessages$java_util_Locale", new Object[]{locale});
            map = this.__M_getAllMessages(locale);
            this.__IM.onExit((Object)this, "getAllMessages$java_util_Locale", map);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getAllMessages$java_util_Locale", throwable);
            throw throwable;
        }
        return map;
    }

    private Map<String, String> __M_getAllMessages(Locale locale) {
        return this.getAllMessages(new Locale[]{locale});
    }

    public Map<String, String> getAllMessages(Locale ... locales) {
        Map<String, String> map;
        if (!this.__MgetAllMessages$java_util_Locale__) {
            return this.__M_getAllMessages(locales);
        }
        try {
            this.__IM.onEntry((Object)this, "getAllMessages$java_util_Locale__", new Object[]{locales});
            map = this.__M_getAllMessages(locales);
            this.__IM.onExit((Object)this, "getAllMessages$java_util_Locale__", map);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getAllMessages$java_util_Locale__", throwable);
            throw throwable;
        }
        return map;
    }

    private Map<String, String> __M_getAllMessages(Locale[] locales) {
        List<I18nExtension> extensionForLocale;
        HashMap<String, String> messages = new HashMap<String, String>();
        for (Locale locale : locales) {
            extensionForLocale = this.getExtension(locale);
            for (I18nExtension extension : extensionForLocale) {
                this.merge(messages, extension.map());
            }
        }
        extensionForLocale = this.getExtension(DEFAULT_LOCALE);
        for (I18nExtension extension : extensionForLocale) {
            this.merge(messages, extension.map());
        }
        return messages;
    }

    public String etag(Locale locale) {
        String string;
        if (!this.__Metag$java_util_Locale) {
            return this.__M_etag(locale);
        }
        try {
            this.__IM.onEntry((Object)this, "etag$java_util_Locale", new Object[]{locale});
            string = this.__M_etag(locale);
            this.__IM.onExit((Object)this, "etag$java_util_Locale", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "etag$java_util_Locale", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_etag(Locale locale) {
        String etag = (String)this.__getetags().get(locale);
        if (etag == null) {
            return "0";
        }
        return etag;
    }

    private void merge(Map<String, String> map1, Map<String, String> map2) {
        if (!this.__Mmerge$java_util_Map$java_util_Map) {
            this.__M_merge(map1, map2);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "merge$java_util_Map$java_util_Map", new Object[]{map1, map2});
            this.__M_merge(map1, map2);
            this.__IM.onExit((Object)this, "merge$java_util_Map$java_util_Map", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "merge$java_util_Map$java_util_Map", throwable);
            throw throwable;
        }
    }

    private void __M_merge(Map<String, String> map1, Map<String, String> map2) {
        for (Map.Entry<String, String> entry : map2.entrySet()) {
            if (map1.containsKey(entry.getKey())) continue;
            map1.put(entry.getKey(), entry.getValue());
        }
    }

    private List<I18nExtension> getExtension(Locale locale) {
        List<I18nExtension> list;
        if (!this.__MgetExtension$java_util_Locale) {
            return this.__M_getExtension(locale);
        }
        try {
            this.__IM.onEntry((Object)this, "getExtension$java_util_Locale", new Object[]{locale});
            list = this.__M_getExtension(locale);
            this.__IM.onExit((Object)this, "getExtension$java_util_Locale", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getExtension$java_util_Locale", throwable);
            throw throwable;
        }
        return list;
    }

    private List<I18nExtension> __M_getExtension(Locale locale) {
        if (locale.equals(this.__getdefaultLocale())) {
            locale = InternationalizationService.DEFAULT_LOCALE;
        }
        ArrayList<I18nExtension> list = new ArrayList<I18nExtension>();
        for (I18nExtension extension : this.__getextensions()) {
            if (extension.locale().equals(locale)) {
                list.add(extension);
                continue;
            }
            if (!locale.equals(this.__getdefaultLocale()) || !extension.locale().equals(DEFAULT_LOCALE)) continue;
            list.add(extension);
        }
        return list;
    }

    private I18nExtension getExtension(Locale locale, String key) {
        I18nExtension i18nExtension;
        if (!this.__MgetExtension$java_util_Locale$java_lang_String) {
            return this.__M_getExtension(locale, key);
        }
        try {
            this.__IM.onEntry((Object)this, "getExtension$java_util_Locale$java_lang_String", new Object[]{locale, key});
            i18nExtension = this.__M_getExtension(locale, key);
            this.__IM.onExit((Object)this, "getExtension$java_util_Locale$java_lang_String", (Object)i18nExtension);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getExtension$java_util_Locale$java_lang_String", throwable);
            throw throwable;
        }
        return i18nExtension;
    }

    private I18nExtension __M_getExtension(Locale locale, String key) {
        if (locale.equals(this.__getdefaultLocale())) {
            locale = InternationalizationService.DEFAULT_LOCALE;
        }
        for (I18nExtension extension : this.__getextensions()) {
            if (!extension.locale().equals(locale) || !extension.keys().contains(key)) continue;
            return extension;
        }
        return null;
    }

    public List<I18nExtension> addingBundle(Bundle bundle, BundleEvent event) {
        Object object;
        if (!this.__MaddingBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent) {
            return this.__M_addingBundle(bundle, event);
        }
        try {
            this.__IM.onEntry((Object)this, "addingBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent", new Object[]{bundle, event});
            object = this.__M_addingBundle(bundle, event);
            this.__IM.onExit((Object)this, "addingBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addingBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent", throwable);
            throw throwable;
        }
        return object;
    }

    private List<I18nExtension> __M_addingBundle(Bundle bundle, BundleEvent event) {
        List<I18nExtension> list = ExtenderUtils.analyze("/i18n/", bundle);
        if (list.isEmpty()) {
            return null;
        }
        String current = Long.toString(System.currentTimeMillis());
        LOGGER.info(list.size() + " resource bundle(s) loaded from {} ({})", (Object)bundle.getSymbolicName(), (Object)bundle.getBundleId());
        for (I18nExtension extension : list) {
            this.__getextensions().add(extension);
            this.__getetags().put(extension.locale(), current);
        }
        return list;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, List<I18nExtension> object) {
        if (!this.__MmodifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List) {
            this.__M_modifiedBundle(bundle, event, object);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "modifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List", new Object[]{bundle, event, object});
            this.__M_modifiedBundle(bundle, event, object);
            this.__IM.onExit((Object)this, "modifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "modifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List", throwable);
            throw throwable;
        }
    }

    private void __M_modifiedBundle(Bundle bundle, BundleEvent event, List<I18nExtension> object) {
    }

    public void removedBundle(Bundle bundle, BundleEvent event, List<I18nExtension> list) {
        if (!this.__MremovedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List) {
            this.__M_removedBundle(bundle, event, list);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List", new Object[]{bundle, event, list});
            this.__M_removedBundle(bundle, event, list);
            this.__IM.onExit((Object)this, "removedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_removedBundle(Bundle bundle, BundleEvent event, List<I18nExtension> list) {
        String current = Long.toString(System.currentTimeMillis());
        for (I18nExtension extension : list) {
            InternationalizationServiceSingleton internationalizationServiceSingleton = this;
            synchronized (internationalizationServiceSingleton) {
                this.__getextensions().remove(extension);
                this.__getetags().put(extension.locale(), current);
            }
        }
        LOGGER.info("Bundle {} ({}) does not offer the {} resource bundle(s) anymore", new Object[]{bundle.getSymbolicName(), bundle.getBundleId(), list.size()});
    }

    private void __M_removedBundle(Bundle bundle, BundleEvent bundleEvent, Object object) {
        this.removedBundle(bundle, bundleEvent, (List)object);
    }

    private void __M_modifiedBundle(Bundle bundle, BundleEvent bundleEvent, Object object) {
        this.modifiedBundle(bundle, bundleEvent, (List)object);
    }

    private Object __M_addingBundle(Bundle bundle, BundleEvent bundleEvent) {
        return this.addingBundle(bundle, bundleEvent);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("configuration")) {
                this.__Fconfiguration = true;
            }
            if (set.contains("context")) {
                this.__Fcontext = true;
            }
            if (set.contains("defaultLocale")) {
                this.__FdefaultLocale = true;
            }
            if (set.contains("etags")) {
                this.__Fetags = true;
            }
            if (set.contains("extensions")) {
                this.__Fextensions = true;
            }
            if (set.contains("tracker")) {
                this.__Ftracker = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("getDefaultLocale")) {
                this.__MgetDefaultLocale = true;
            }
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("defaultLocale")) {
                this.__MdefaultLocale = true;
            }
            if (set.contains("bundles")) {
                this.__Mbundles = true;
            }
            if (set.contains("bundles$java_util_Locale")) {
                this.__Mbundles$java_util_Locale = true;
            }
            if (set.contains("get$java_util_Locale__$java_lang_String$java_lang_Object__")) {
                this.__Mget$java_util_Locale__$java_lang_String$java_lang_Object__ = true;
            }
            if (set.contains("get$java_util_Locale$java_lang_String$java_lang_Object__")) {
                this.__Mget$java_util_Locale$java_lang_String$java_lang_Object__ = true;
            }
            if (set.contains("getAllMessages$java_util_Locale")) {
                this.__MgetAllMessages$java_util_Locale = true;
            }
            if (set.contains("getAllMessages$java_util_Locale__")) {
                this.__MgetAllMessages$java_util_Locale__ = true;
            }
            if (set.contains("etag$java_util_Locale")) {
                this.__Metag$java_util_Locale = true;
            }
            if (set.contains("merge$java_util_Map$java_util_Map")) {
                this.__Mmerge$java_util_Map$java_util_Map = true;
            }
            if (set.contains("getExtension$java_util_Locale")) {
                this.__MgetExtension$java_util_Locale = true;
            }
            if (set.contains("getExtension$java_util_Locale$java_lang_String")) {
                this.__MgetExtension$java_util_Locale$java_lang_String = true;
            }
            if (set.contains("addingBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent")) {
                this.__MaddingBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent = true;
            }
            if (set.contains("modifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List")) {
                this.__MmodifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List = true;
            }
            if (set.contains("removedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List")) {
                this.__MremovedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List = true;
            }
            if (set.contains("removedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_lang_Object")) {
                this.__MremovedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_lang_Object = true;
            }
            if (set.contains("modifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_lang_Object")) {
                this.__MmodifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_lang_Object = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

