/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.cache.ehcache;

import com.google.common.base.Strings;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.api.cache.Cache;
import org.wisdom.api.cache.Cached;
import org.wisdom.api.http.Result;
import org.wisdom.api.interception.Interceptor;
import org.wisdom.api.interception.RequestContext;

@Component
@Provides(specifications={Interceptor.class})
@Instantiate
public class CachedActionInterceptor
extends Interceptor<Cached> {
    InstanceManager __IM;
    private boolean __Fcache;
    @Requires
    protected Cache cache;
    private static final Logger LOGGER = LoggerFactory.getLogger(CachedActionInterceptor.class);
    boolean __Mcall$org_wisdom_api_cache_Cached$org_wisdom_api_interception_RequestContext;
    boolean __Mannotation;
    boolean __Mcall$java_lang_Object$org_wisdom_api_interception_RequestContext;

    Cache __getcache() {
        if (!this.__Fcache) {
            return this.cache;
        }
        return (Cache)this.__IM.onGet((Object)this, "cache");
    }

    void __setcache(Cache cache) {
        if (!this.__Fcache) {
            this.cache = cache;
            return;
        }
        this.__IM.onSet((Object)this, "cache", (Object)cache);
    }

    public CachedActionInterceptor() {
        this(null);
    }

    private CachedActionInterceptor(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public Result call(Cached configuration, RequestContext context) throws Exception {
        Result result;
        if (!this.__Mcall$org_wisdom_api_cache_Cached$org_wisdom_api_interception_RequestContext) {
            return this.__M_call(configuration, context);
        }
        try {
            this.__IM.onEntry((Object)this, "call$org_wisdom_api_cache_Cached$org_wisdom_api_interception_RequestContext", new Object[]{configuration, context});
            result = this.__M_call(configuration, context);
            this.__IM.onExit((Object)this, "call$org_wisdom_api_cache_Cached$org_wisdom_api_interception_RequestContext", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "call$org_wisdom_api_cache_Cached$org_wisdom_api_interception_RequestContext", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_call(Cached configuration, RequestContext context) throws Exception {
        boolean nocache = "no-cache".equalsIgnoreCase(context.context().header("Cache-Control"));
        String key = Strings.isNullOrEmpty((String)configuration.key()) ? context.request().uri() : configuration.key();
        Result result = null;
        if (!nocache) {
            result = (Result)this.__getcache().get(key);
        }
        if (result != null) {
            LOGGER.info("Returning cached result for {} (key:{})", (Object)context.request().uri(), (Object)key);
            return result;
        }
        result = context.proceed();
        Duration duration = configuration.duration() == 0 ? Duration.standardDays((long)365L) : Duration.standardSeconds((long)configuration.duration());
        this.__getcache().set(key, (Object)result, duration);
        LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Caching result of {} for {} seconds (key:{})", new Object[]{context.request().uri(), configuration.duration(), key});
        return result;
    }

    public Class<Cached> annotation() {
        Class<Cached> clazz;
        if (!this.__Mannotation) {
            return this.__M_annotation();
        }
        try {
            this.__IM.onEntry((Object)this, "annotation", new Object[0]);
            clazz = this.__M_annotation();
            this.__IM.onExit((Object)this, "annotation", clazz);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "annotation", throwable);
            throw throwable;
        }
        return clazz;
    }

    private Class<Cached> __M_annotation() {
        return Cached.class;
    }

    private Result __M_call(Object object, RequestContext requestContext) throws Exception {
        return this.call((Cached)object, requestContext);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null && set.contains("cache")) {
            this.__Fcache = true;
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("call$org_wisdom_api_cache_Cached$org_wisdom_api_interception_RequestContext")) {
                this.__Mcall$org_wisdom_api_cache_Cached$org_wisdom_api_interception_RequestContext = true;
            }
            if (set.contains("annotation")) {
                this.__Mannotation = true;
            }
            if (set.contains("call$java_lang_Object$org_wisdom_api_interception_RequestContext")) {
                this.__Mcall$java_lang_Object$org_wisdom_api_interception_RequestContext = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

