/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ow2.chameleon.core.Chameleon;
import org.slf4j.LoggerFactory;

public class Main {
    public static final String INTERACTIVE_ARGUMENT = "--interactive";

    private Main() {
    }

    public static void main(String[] args) {
        Chameleon chameleon;
        try {
            chameleon = Main.createChameleon(args);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(Chameleon.class).error("Cannot initialize the Chameleon instance", (Throwable)e);
            return;
        }
        Main.registerShutdownHook(chameleon);
        try {
            chameleon.start();
        }
        catch (Exception e) {
            LoggerFactory.getLogger(Chameleon.class).error("Cannot start the Chameleon instance", (Throwable)e);
        }
    }

    public static Chameleon createChameleon(String[] args) throws IOException {
        boolean interactive = Main.isInteractiveModeEnabled(args);
        Map<String, Object> map = Main.parseUserProperties(args);
        return new Chameleon(interactive, map);
    }

    public static Map<String, Object> parseUserProperties(String[] args) {
        if (args == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String arg : args) {
            if (!arg.startsWith("-D")) continue;
            if ((arg = arg.substring(2)).contains("=")) {
                String k = arg.substring(0, arg.indexOf("="));
                String v = arg.substring(arg.indexOf("=") + 1);
                map.put(k, v);
                continue;
            }
            map.put(arg, Boolean.TRUE);
        }
        return map;
    }

    private static void registerShutdownHook(final Chameleon chameleon) {
        Runtime runtime = Runtime.getRuntime();
        Runnable hook = new Runnable(){

            @Override
            public void run() {
                try {
                    if (chameleon != null) {
                        chameleon.stop();
                    }
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(Chameleon.class).error("Cannot stop the Chameleon instance on JVM shutdown", (Throwable)e);
                }
            }
        };
        runtime.addShutdownHook(new Thread(hook));
    }

    private static boolean isInteractiveModeEnabled(String[] args) {
        if (args == null) {
            return false;
        }
        for (String arg : args) {
            if (!INTERACTIVE_ARGUMENT.equalsIgnoreCase(arg)) continue;
            return true;
        }
        return false;
    }
}

