/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core.activators;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.ow2.chameleon.core.services.AbstractStabilityChecker;
import org.ow2.chameleon.core.services.StabilityResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceStabilityChecker
extends AbstractStabilityChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceStabilityChecker.class);
    private final BundleContext context;
    private final int attempts;

    public ServiceStabilityChecker(BundleContext context) {
        this(context, ServiceStabilityChecker.getDefaultNumberOfAttempts());
    }

    public ServiceStabilityChecker(BundleContext context, int maxAttempt) {
        this.context = context;
        this.attempts = maxAttempt;
    }

    @Override
    public String getName() {
        return "Service Stability";
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public StabilityResult check() {
        int count;
        boolean serviceStability = false;
        int count1 = 0;
        int count2 = 0;
        for (count = 0; !serviceStability && count < this.attempts; ++count) {
            try {
                ServiceReference<?>[] refs = this.context.getAllServiceReferences(null, null);
                count1 = refs.length;
                ServiceStabilityChecker.grace();
                refs = this.context.getAllServiceReferences(null, null);
                count2 = refs.length;
                serviceStability = count1 == count2;
                continue;
            }
            catch (Exception e) {
                LOGGER.warn("An exception was thrown while checking the service stability", (Throwable)e);
                serviceStability = false;
            }
        }
        if (count == this.attempts) {
            LOGGER.error("Service stability has not been reached after {} tries ({} != {})", new Object[]{this.attempts, count1, count2});
            return StabilityResult.unstable("Cannot reach the service stability");
        }
        return StabilityResult.stable();
    }
}

