/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core.utils;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public final class FrameworkClassLoader
extends URLClassLoader {
    private static List<String> PREFIXES = ImmutableList.of((Object)"org.apache.felix.framework");
    private Map<String, Class> classes = new HashMap<String, Class>();
    protected final URLClassLoader libsClassLoader;

    public static ClassLoader getFrameworkClassLoader(final File basedir) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return new FrameworkClassLoader(basedir, null);
            }
        });
    }

    public static ClassLoader getFrameworkClassLoader(final File basedir, final Map<String, String> configuration) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                if (configuration != null) {
                    return new FrameworkClassLoader(basedir, (String)configuration.get("chameleon.libraries.parent"));
                }
                return new FrameworkClassLoader(basedir, null);
            }
        });
    }

    private FrameworkClassLoader(File basedir, String librariesParentPolicy) {
        super(FrameworkClassLoader.jars(new File(basedir.getAbsoluteFile(), "libs")), FrameworkClassLoader.class.getClassLoader());
        ClassLoader parent = null;
        if (librariesParentPolicy == null || "system".equalsIgnoreCase(librariesParentPolicy)) {
            parent = null;
        } else if ("application".equalsIgnoreCase(librariesParentPolicy)) {
            parent = FrameworkClassLoader.class.getClassLoader();
        } else if ("parent".equalsIgnoreCase(librariesParentPolicy)) {
            parent = FrameworkClassLoader.class.getClassLoader().getParent();
        } else {
            throw new IllegalArgumentException("Unrecognized 'chameleon.libraries.parent', are supported: {system, application and parent}");
        }
        this.libsClassLoader = new URLClassLoader(FrameworkClassLoader.jars(new File(basedir.getAbsoluteFile(), "libs")), parent);
    }

    public static boolean hasToBeDefined(String name) {
        for (String p : PREFIXES) {
            if (!name.startsWith(p) && !name.equals(p)) continue;
            return true;
        }
        return false;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        if (this.classes.containsKey(name)) {
            return this.classes.get(name);
        }
        if (FrameworkClassLoader.hasToBeDefined(name)) {
            try {
                byte[] bytes = this.getByteCode(name);
                if (bytes.length != 0) {
                    Class<?> c = this.defineClass(name, bytes, 0, bytes.length, FrameworkClassLoader.class.getProtectionDomain());
                    this.classes.put(name, c);
                    return c;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        try {
            return this.libsClassLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return super.loadClass(name);
        }
    }

    private byte[] getByteCode(String classname) throws IOException {
        URL url = this.getResource(classname.replace(".", "/") + ".class");
        if (url == null) {
            return new byte[0];
        }
        return IOUtils.toByteArray((URL)url);
    }

    public static URL[] jars(File dir) {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (dir.isDirectory()) {
            for (File jar : FileUtils.listFiles((File)dir, (String[])new String[]{"jar"}, (boolean)true)) {
                try {
                    urls.add(jar.toURI().toURL());
                }
                catch (MalformedURLException e) {}
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }
}

