/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.monitor;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.Validate;
import org.wisdom.api.DefaultController;
import org.wisdom.api.annotations.Controller;
import org.wisdom.api.annotations.FormParameter;
import org.wisdom.api.annotations.Route;
import org.wisdom.api.annotations.View;
import org.wisdom.api.configuration.ApplicationConfiguration;
import org.wisdom.api.content.JacksonModuleRepository;
import org.wisdom.api.http.HttpMethod;
import org.wisdom.api.http.Result;
import org.wisdom.api.security.Authenticated;
import org.wisdom.api.templates.Template;
import org.wisdom.monitor.service.MonitorExtension;

@Controller
public class MonitorCenter
extends DefaultController
implements Pojo {
    InstanceManager __IM;
    boolean __M1___serialize$org_wisdom_monitor_service_MonitorExtension$com_fasterxml_jackson_core_JsonGenerator$com_fasterxml_jackson_databind_SerializerProvider;
    boolean __M1___serialize$java_lang_Object$com_fasterxml_jackson_core_JsonGenerator$com_fasterxml_jackson_databind_SerializerProvider;
    private boolean __Fextensions;
    @Requires(specification=MonitorExtension.class)
    List<MonitorExtension> extensions;
    private boolean __Frepository;
    @Requires
    JacksonModuleRepository repository;
    private boolean __Fmodule;
    private SimpleModule module;
    private boolean __Fconfiguration;
    @Requires
    ApplicationConfiguration configuration;
    private boolean __FloginTemplate;
    @View(value="monitor/login")
    Template loginTemplate;
    boolean __Mstart;
    boolean __Mstop;
    boolean __Mlogin;
    boolean __Mlogout;
    boolean __Mauthenticate$java_lang_String$java_lang_String;
    boolean __Mdashboard;
    boolean __MgetExtensionByName$java_lang_String;
    boolean __MgetExtensions;

    List __getextensions() {
        if (!this.__Fextensions) {
            return this.extensions;
        }
        return (List)this.__IM.onGet((Object)this, "extensions");
    }

    void __setextensions(List list) {
        if (!this.__Fextensions) {
            this.extensions = list;
            return;
        }
        this.__IM.onSet((Object)this, "extensions", (Object)list);
    }

    JacksonModuleRepository __getrepository() {
        if (!this.__Frepository) {
            return this.repository;
        }
        return (JacksonModuleRepository)this.__IM.onGet((Object)this, "repository");
    }

    void __setrepository(JacksonModuleRepository jacksonModuleRepository) {
        if (!this.__Frepository) {
            this.repository = jacksonModuleRepository;
            return;
        }
        this.__IM.onSet((Object)this, "repository", (Object)jacksonModuleRepository);
    }

    SimpleModule __getmodule() {
        if (!this.__Fmodule) {
            return this.module;
        }
        return (SimpleModule)this.__IM.onGet((Object)this, "module");
    }

    void __setmodule(SimpleModule simpleModule) {
        if (!this.__Fmodule) {
            this.module = simpleModule;
            return;
        }
        this.__IM.onSet((Object)this, "module", (Object)simpleModule);
    }

    ApplicationConfiguration __getconfiguration() {
        if (!this.__Fconfiguration) {
            return this.configuration;
        }
        return (ApplicationConfiguration)this.__IM.onGet((Object)this, "configuration");
    }

    void __setconfiguration(ApplicationConfiguration applicationConfiguration) {
        if (!this.__Fconfiguration) {
            this.configuration = applicationConfiguration;
            return;
        }
        this.__IM.onSet((Object)this, "configuration", (Object)applicationConfiguration);
    }

    Template __getloginTemplate() {
        if (!this.__FloginTemplate) {
            return this.loginTemplate;
        }
        return (Template)this.__IM.onGet((Object)this, "loginTemplate");
    }

    void __setloginTemplate(Template template) {
        if (!this.__FloginTemplate) {
            this.loginTemplate = template;
            return;
        }
        this.__IM.onSet((Object)this, "loginTemplate", (Object)template);
    }

    public MonitorCenter() {
        this(null);
    }

    private MonitorCenter(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setextensions(new ArrayList());
    }

    public void start() {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __M_start() {
        this.__setmodule(new SimpleModule(MonitorExtension.class.getName()));
        this.__getmodule().addSerializer(MonitorExtension.class, (JsonSerializer)new JsonSerializer<MonitorExtension>(){

            public void serialize(MonitorExtension monitorExtension, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                if (!MonitorCenter.this.__M1___serialize$org_wisdom_monitor_service_MonitorExtension$com_fasterxml_jackson_core_JsonGenerator$com_fasterxml_jackson_databind_SerializerProvider) {
                    this.__M_serialize(monitorExtension, jsonGenerator, serializerProvider);
                    return;
                }
                try {
                    MonitorCenter.this.__IM.onEntry((Object)this, "1___serialize$org_wisdom_monitor_service_MonitorExtension$com_fasterxml_jackson_core_JsonGenerator$com_fasterxml_jackson_databind_SerializerProvider", new Object[]{monitorExtension, jsonGenerator, serializerProvider});
                    this.__M_serialize(monitorExtension, jsonGenerator, serializerProvider);
                    MonitorCenter.this.__IM.onExit((Object)this, "1___serialize$org_wisdom_monitor_service_MonitorExtension$com_fasterxml_jackson_core_JsonGenerator$com_fasterxml_jackson_databind_SerializerProvider", null);
                }
                catch (Throwable throwable) {
                    MonitorCenter.this.__IM.onError((Object)this, "1___serialize$org_wisdom_monitor_service_MonitorExtension$com_fasterxml_jackson_core_JsonGenerator$com_fasterxml_jackson_databind_SerializerProvider", throwable);
                    throw throwable;
                }
            }

            private void __M_serialize(MonitorExtension monitorExtension, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeStringField("label", monitorExtension.label());
                jsonGenerator.writeStringField("url", monitorExtension.url());
                jsonGenerator.writeStringField("category", monitorExtension.category());
                jsonGenerator.writeEndObject();
            }

            private void __M_serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
                this.serialize((MonitorExtension)object, jsonGenerator, serializerProvider);
            }
        });
        this.__getrepository().register((Module)this.__getmodule());
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __M_stop() {
        if (this.__getmodule() != null) {
            this.__getrepository().unregister((Module)this.__getmodule());
        }
    }

    @Route(uri="/monitor/login", method=HttpMethod.GET)
    public Result login() {
        Result result;
        if (!this.__Mlogin) {
            return this.__M_login();
        }
        try {
            this.__IM.onEntry((Object)this, "login", new Object[0]);
            result = this.__M_login();
            this.__IM.onExit((Object)this, "login", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "login", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_login() {
        if (!this.__getconfiguration().getBooleanWithDefault("monitor.auth.enabled", Boolean.valueOf(true)).booleanValue()) {
            return this.dashboard();
        }
        return MonitorCenter.ok((Object)this.render(this.__getloginTemplate()));
    }

    @Route(uri="/monitor/logout", method=HttpMethod.GET)
    public Result logout() {
        Result result;
        if (!this.__Mlogout) {
            return this.__M_logout();
        }
        try {
            this.__IM.onEntry((Object)this, "logout", new Object[0]);
            result = this.__M_logout();
            this.__IM.onExit((Object)this, "logout", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "logout", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_logout() {
        this.context().session().remove("wisdom.monitor.username");
        return this.login();
    }

    @Route(uri="/monitor/login", method=HttpMethod.POST)
    public Result authenticate(@FormParameter(value="username") String username, @FormParameter(value="password") String password) {
        Result result;
        if (!this.__Mauthenticate$java_lang_String$java_lang_String) {
            return this.__M_authenticate(username, password);
        }
        try {
            this.__IM.onEntry((Object)this, "authenticate$java_lang_String$java_lang_String", new Object[]{username, password});
            result = this.__M_authenticate(username, password);
            this.__IM.onExit((Object)this, "authenticate$java_lang_String$java_lang_String", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "authenticate$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_authenticate(String username, String password) {
        if (!this.__getconfiguration().getBooleanWithDefault("monitor.auth.enabled", Boolean.valueOf(true)).booleanValue()) {
            return this.dashboard();
        }
        String name = this.__getconfiguration().getOrDie("monitor.auth.username");
        String pwd = this.__getconfiguration().getOrDie("monitor.auth.password");
        if (name.equals(username) && pwd.equals(password)) {
            this.session().put("wisdom.monitor.username", username);
            this.logger().info("Authentication successful - {}", (Object)username);
            return this.dashboard();
        }
        this.logger().info("Authentication failed - {}", (Object)username);
        this.context().flash().error("Authentication failed - check your credentials");
        return this.login();
    }

    @Authenticated(value="Monitor-Authenticator")
    @Route(uri="/monitor", method=HttpMethod.GET)
    public Result dashboard() {
        Result result;
        if (!this.__Mdashboard) {
            return this.__M_dashboard();
        }
        try {
            this.__IM.onEntry((Object)this, "dashboard", new Object[0]);
            result = this.__M_dashboard();
            this.__IM.onExit((Object)this, "dashboard", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "dashboard", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_dashboard() {
        String extension = this.__getconfiguration().getWithDefault("monitor.default", "dashboard");
        return MonitorCenter.redirect((String)this.getExtensionByName(extension).url());
    }

    private MonitorExtension getExtensionByName(String name) {
        MonitorExtension monitorExtension;
        if (!this.__MgetExtensionByName$java_lang_String) {
            return this.__M_getExtensionByName(name);
        }
        try {
            this.__IM.onEntry((Object)this, "getExtensionByName$java_lang_String", new Object[]{name});
            monitorExtension = this.__M_getExtensionByName(name);
            this.__IM.onExit((Object)this, "getExtensionByName$java_lang_String", (Object)monitorExtension);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getExtensionByName$java_lang_String", throwable);
            throw throwable;
        }
        return monitorExtension;
    }

    private MonitorExtension __M_getExtensionByName(String name) {
        for (MonitorExtension extension : this.__getextensions()) {
            if (!extension.label().equalsIgnoreCase(name)) continue;
            return extension;
        }
        return null;
    }

    @Authenticated(value="Monitor-Authenticator")
    @Route(uri="/monitor/extensions", method=HttpMethod.GET)
    public Result getExtensions() {
        Result result;
        if (!this.__MgetExtensions) {
            return this.__M_getExtensions();
        }
        try {
            this.__IM.onEntry((Object)this, "getExtensions", new Object[0]);
            result = this.__M_getExtensions();
            this.__IM.onExit((Object)this, "getExtensions", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getExtensions", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_getExtensions() {
        return MonitorCenter.ok((Object)this.__getextensions()).json();
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("configuration")) {
                this.__Fconfiguration = true;
            }
            if (set.contains("extensions")) {
                this.__Fextensions = true;
            }
            if (set.contains("loginTemplate")) {
                this.__FloginTemplate = true;
            }
            if (set.contains("module")) {
                this.__Fmodule = true;
            }
            if (set.contains("repository")) {
                this.__Frepository = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("1___serialize$org_wisdom_monitor_service_MonitorExtension$com_fasterxml_jackson_core_JsonGenerator$com_fasterxml_jackson_databind_SerializerProvider")) {
                this.__M1___serialize$org_wisdom_monitor_service_MonitorExtension$com_fasterxml_jackson_core_JsonGenerator$com_fasterxml_jackson_databind_SerializerProvider = true;
            }
            if (set.contains("1___serialize$java_lang_Object$com_fasterxml_jackson_core_JsonGenerator$com_fasterxml_jackson_databind_SerializerProvider")) {
                this.__M1___serialize$java_lang_Object$com_fasterxml_jackson_core_JsonGenerator$com_fasterxml_jackson_databind_SerializerProvider = true;
            }
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("login")) {
                this.__Mlogin = true;
            }
            if (set.contains("logout")) {
                this.__Mlogout = true;
            }
            if (set.contains("authenticate$java_lang_String$java_lang_String")) {
                this.__Mauthenticate$java_lang_String$java_lang_String = true;
            }
            if (set.contains("dashboard")) {
                this.__Mdashboard = true;
            }
            if (set.contains("getExtensionByName$java_lang_String")) {
                this.__MgetExtensionByName$java_lang_String = true;
            }
            if (set.contains("getExtensions")) {
                this.__MgetExtensions = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

