/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.monitor.extensions.dashboard;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.google.common.collect.ImmutableMap;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.Map;

public class CpuGaugeSet
implements MetricSet {
    public static final String PROCESSORS = "processors";
    public static final String SYSTEM_LOAD_AVERAGE = "systemLoadAverage";
    public static final String CPU_SYSTEM_LOAD = "cpuSystemLoad";
    public static final String CPU_PROCESS_LOAD = "cpuProcessLoad";
    public static final String CPU_PROCESS_TIME = "cpuProcessTime";
    private java.lang.management.OperatingSystemMXBean bean = ManagementFactory.getOperatingSystemMXBean();

    public Map<String, Metric> getMetrics() {
        return ImmutableMap.of((Object)PROCESSORS, (Object)new Gauge<Integer>(){

            public Integer getValue() {
                return CpuGaugeSet.this.bean.getAvailableProcessors();
            }
        }, (Object)SYSTEM_LOAD_AVERAGE, (Object)new Gauge<Double>(){

            public Double getValue() {
                return CpuGaugeSet.this.bean.getSystemLoadAverage();
            }
        }, (Object)CPU_SYSTEM_LOAD, (Object)new Gauge<Double>(){

            public Double getValue() {
                return CpuGaugeSet.this.getSystemCpuLoad();
            }
        }, (Object)CPU_PROCESS_LOAD, (Object)new Gauge<Double>(){

            public Double getValue() {
                return CpuGaugeSet.this.getCpuProcessLoad();
            }
        }, (Object)CPU_PROCESS_TIME, (Object)new Gauge<Long>(){

            public Long getValue() {
                return CpuGaugeSet.this.getCpuTime();
            }
        });
    }

    private Double getSystemCpuLoad() {
        if (this.bean instanceof OperatingSystemMXBean) {
            return ((OperatingSystemMXBean)this.bean).getSystemCpuLoad() * 100.0;
        }
        return -1.0;
    }

    private Double getCpuProcessLoad() {
        if (this.bean instanceof OperatingSystemMXBean) {
            return ((OperatingSystemMXBean)this.bean).getProcessCpuLoad() * 100.0;
        }
        return -1.0;
    }

    private Long getCpuTime() {
        if (this.bean instanceof OperatingSystemMXBean) {
            return ((OperatingSystemMXBean)this.bean).getProcessCpuTime();
        }
        return -1L;
    }
}

