/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.monitor.extensions.ipojo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.felix.ipojo.architecture.Architecture;
import org.apache.felix.ipojo.handlers.dependency.DependencyDescription;
import org.apache.felix.ipojo.handlers.dependency.DependencyHandlerDescription;
import org.apache.felix.ipojo.handlers.providedservice.ProvidedServiceDescription;
import org.apache.felix.ipojo.handlers.providedservice.ProvidedServiceHandlerDescription;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class InstanceModel {
    private final Architecture architecture;

    public InstanceModel(Architecture architecture) {
        this.architecture = architecture;
    }

    public static List<InstanceModel> instances(BundleContext context) {
        ArrayList<InstanceModel> instances = new ArrayList<InstanceModel>();
        try {
            for (ServiceReference ref : context.getServiceReferences(Architecture.class, null)) {
                instances.add(new InstanceModel((Architecture)context.getService(ref)));
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        return instances;
    }

    public String getName() {
        return this.architecture.getInstanceDescription().getName();
    }

    public String getArchitecture() {
        return this.architecture.getInstanceDescription().getDescription().toString().replace("\t", " ").replace("  ", " ");
    }

    public String getFactory() {
        return this.architecture.getInstanceDescription().getComponentDescription().getName();
    }

    public String getState() {
        switch (this.architecture.getInstanceDescription().getState()) {
            case -1: {
                return "DISPOSED";
            }
            case 1: {
                return "INVALID";
            }
            case 2: {
                return "VALID";
            }
            case 0: {
                return "STOPPED";
            }
        }
        return "UNKNOWN";
    }

    public List<ProvidedServiceModel> getServices() {
        ProvidedServiceHandlerDescription pshd = (ProvidedServiceHandlerDescription)this.architecture.getInstanceDescription().getHandlerDescription("org.apache.felix.ipojo:provides");
        if (pshd == null) {
            return Collections.emptyList();
        }
        ArrayList<ProvidedServiceModel> list = new ArrayList<ProvidedServiceModel>(pshd.getProvidedServices().length);
        for (ProvidedServiceDescription description : pshd.getProvidedServices()) {
            list.add(new ProvidedServiceModel(description));
        }
        return list;
    }

    public List<ServiceDependencyModel> getDependencies() {
        DependencyHandlerDescription handler = (DependencyHandlerDescription)this.architecture.getInstanceDescription().getHandlerDescription("org.apache.felix.ipojo:requires");
        if (handler == null) {
            return Collections.emptyList();
        }
        ArrayList<ServiceDependencyModel> list = new ArrayList<ServiceDependencyModel>(handler.getDependencies().length);
        for (DependencyDescription dependency : handler.getDependencies()) {
            list.add(new ServiceDependencyModel(dependency));
        }
        return list;
    }

    private class ServiceDependencyModel {
        private final DependencyDescription dependency;

        public ServiceDependencyModel(DependencyDescription dependency) {
            this.dependency = dependency;
        }

        public boolean isResolved() {
            return this.dependency.getState() == 1;
        }

        public String getInterface() {
            return this.dependency.getSpecification();
        }

        public boolean isOptional() {
            return this.dependency.isOptional();
        }

        public boolean isAggregate() {
            return this.dependency.isMultiple();
        }

        public String getFilter() {
            return this.dependency.getFilter();
        }
    }

    private class ProvidedServiceModel {
        private final ProvidedServiceDescription description;

        private ProvidedServiceModel(ProvidedServiceDescription desc) {
            this.description = desc;
        }

        public String[] getInterfaces() {
            return this.description.getServiceSpecifications();
        }

        public boolean isPublished() {
            return this.description.getState() == 1;
        }

        public Map<String, String> getProperties() {
            TreeMap<String, String> map = new TreeMap<String, String>();
            if (this.isPublished()) {
                String[] keys;
                for (String name : keys = this.description.getServiceReference().getPropertyKeys()) {
                    Object value = this.description.getServiceReference().getProperty(name);
                    if (value != null) {
                        if (value.getClass().isArray()) {
                            map.put(name, Arrays.toString((Object[])value));
                            continue;
                        }
                        map.put(name, value.toString());
                        continue;
                    }
                    map.put(name, "null");
                }
            }
            return map;
        }
    }
}

