/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.monitor.extensions.osgi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ServiceModel {
    private final ServiceReference reference;

    public static List<ServiceModel> services(BundleContext context) {
        ArrayList<ServiceModel> services = new ArrayList<ServiceModel>();
        try {
            ServiceReference[] references = context.getAllServiceReferences(null, null);
            if (references != null) {
                for (ServiceReference ref : references) {
                    services.add(new ServiceModel(ref));
                }
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        return services;
    }

    public ServiceModel(ServiceReference reference) {
        this.reference = reference;
    }

    public String getInterfaces() {
        String[] specs = (String[])this.reference.getProperty("objectClass");
        if (specs == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (String spec : specs) {
            if (builder.length() == 0) {
                builder.append(spec);
                continue;
            }
            builder.append(", ").append(spec);
        }
        return builder.toString();
    }

    public long getId() {
        return (Long)this.reference.getProperty("service.id");
    }

    public String getProvidingBundle() {
        Bundle bundle = this.reference.getBundle();
        StringBuilder builder = new StringBuilder();
        String sn = bundle.getSymbolicName();
        if (sn != null) {
            builder.append(sn);
            builder.append(" [").append(bundle.getBundleId()).append("]");
        } else {
            builder.append("[").append(bundle.getBundleId()).append("]");
        }
        return builder.toString();
    }

    public Map<String, String> getProperties() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (String key : this.reference.getPropertyKeys()) {
            Object value = this.reference.getProperty(key);
            if (value.getClass().isArray()) {
                map.put(key, Arrays.toString((Object[])value));
                continue;
            }
            map.put(key, value.toString());
        }
        return map;
    }
}

