/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.monitor.extensions.osgi;

import com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Context;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Validate;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.wisdom.api.DefaultController;
import org.wisdom.api.annotations.Controller;
import org.wisdom.api.annotations.Path;
import org.wisdom.api.annotations.Route;
import org.wisdom.api.annotations.View;
import org.wisdom.api.http.HttpMethod;
import org.wisdom.api.http.Result;
import org.wisdom.api.security.Authenticated;
import org.wisdom.api.templates.Template;
import org.wisdom.monitor.extensions.osgi.ServiceModel;
import org.wisdom.monitor.service.MonitorExtension;

@Path(value="/monitor/osgi/service")
@Authenticated(value="Monitor-Authenticator")
@Controller
public class ServiceMonitorExtension
extends DefaultController
implements MonitorExtension,
Pojo {
    InstanceManager __IM;
    boolean __MServiceEventCounter___start;
    boolean __MServiceEventCounter___reset;
    boolean __MServiceEventCounter___stop;
    boolean __MServiceEventCounter___get;
    boolean __MServiceEventCounter___serviceChanged$org_osgi_framework_ServiceEvent;
    private boolean __Fservices;
    @View(value="monitor/services")
    Template services;
    private boolean __Fcontext;
    @Context
    BundleContext context;
    private boolean __Fcounter;
    private ServiceEventCounter counter;
    boolean __Mstart;
    boolean __Mstop;
    boolean __Msvc;
    boolean __MgetProviderBundleCount$java_util_List;
    boolean __MgetProviderCount$java_util_List;
    boolean __Mservices;
    boolean __Mlabel;
    boolean __Murl;
    boolean __Mcategory;

    Template __getservices() {
        if (!this.__Fservices) {
            return this.services;
        }
        return (Template)this.__IM.onGet((Object)this, "services");
    }

    void __setservices(Template template) {
        if (!this.__Fservices) {
            this.services = template;
            return;
        }
        this.__IM.onSet((Object)this, "services", (Object)template);
    }

    BundleContext __getcontext() {
        if (!this.__Fcontext) {
            return this.context;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "context");
    }

    void __setcontext(BundleContext bundleContext) {
        if (!this.__Fcontext) {
            this.context = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "context", (Object)bundleContext);
    }

    ServiceEventCounter __getcounter() {
        if (!this.__Fcounter) {
            return this.counter;
        }
        return (ServiceEventCounter)this.__IM.onGet((Object)this, "counter");
    }

    void __setcounter(ServiceEventCounter serviceEventCounter) {
        if (!this.__Fcounter) {
            this.counter = serviceEventCounter;
            return;
        }
        this.__IM.onSet((Object)this, "counter", (Object)serviceEventCounter);
    }

    public ServiceMonitorExtension() {
        this(null);
    }

    private ServiceMonitorExtension(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setcounter(new ServiceEventCounter());
    }

    public void start() {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __M_start() {
        this.__getcounter().start();
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __M_stop() {
        this.__getcounter().stop();
    }

    @Route(uri="", method=HttpMethod.GET)
    public Result svc() {
        Result result;
        if (!this.__Msvc) {
            return this.__M_svc();
        }
        try {
            this.__IM.onEntry((Object)this, "svc", new Object[0]);
            result = this.__M_svc();
            this.__IM.onExit((Object)this, "svc", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "svc", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_svc() {
        return ServiceMonitorExtension.ok((Object)this.render(this.__getservices()));
    }

    private int getProviderBundleCount(List<ServiceModel> svc) {
        int n;
        if (!this.__MgetProviderBundleCount$java_util_List) {
            return this.__M_getProviderBundleCount(svc);
        }
        try {
            this.__IM.onEntry((Object)this, "getProviderBundleCount$java_util_List", new Object[]{svc});
            n = this.__M_getProviderBundleCount(svc);
            this.__IM.onExit((Object)this, "getProviderBundleCount$java_util_List", (Object)new Integer(n));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getProviderBundleCount$java_util_List", throwable);
            throw throwable;
        }
        return n;
    }

    private int __M_getProviderBundleCount(List<ServiceModel> svc) {
        HashSet<String> set = new HashSet<String>();
        for (ServiceModel service : svc) {
            set.add(service.getProvidingBundle());
        }
        return set.size();
    }

    private int getProviderCount(List<ServiceModel> svc) {
        int n;
        if (!this.__MgetProviderCount$java_util_List) {
            return this.__M_getProviderCount(svc);
        }
        try {
            this.__IM.onEntry((Object)this, "getProviderCount$java_util_List", new Object[]{svc});
            n = this.__M_getProviderCount(svc);
            this.__IM.onExit((Object)this, "getProviderCount$java_util_List", (Object)new Integer(n));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getProviderCount$java_util_List", throwable);
            throw throwable;
        }
        return n;
    }

    private int __M_getProviderCount(List<ServiceModel> svc) {
        HashSet<String> set = new HashSet<String>();
        for (ServiceModel service : svc) {
            String name = service.getProperties().get("instance.name");
            if (name == null) continue;
            set.add(name);
        }
        return set.size();
    }

    @Route(uri="/services", method=HttpMethod.GET)
    public Result services() {
        Result result;
        if (!this.__Mservices) {
            return this.__M_services();
        }
        try {
            this.__IM.onEntry((Object)this, "services", new Object[0]);
            result = this.__M_services();
            this.__IM.onExit((Object)this, "services", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "services", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_services() {
        List<ServiceModel> svc = ServiceModel.services(this.__getcontext());
        return ServiceMonitorExtension.ok((Object)ImmutableMap.of((Object)"services", svc, (Object)"events", (Object)this.__getcounter().get(), (Object)"providers", (Object)Integer.toString(this.getProviderCount(svc)), (Object)"bundles", (Object)Integer.toString(this.getProviderBundleCount(svc)))).json();
    }

    @Override
    public String label() {
        String string;
        if (!this.__Mlabel) {
            return this.__M_label();
        }
        try {
            this.__IM.onEntry((Object)this, "label", new Object[0]);
            string = this.__M_label();
            this.__IM.onExit((Object)this, "label", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "label", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_label() {
        return "Services";
    }

    @Override
    public String url() {
        String string;
        if (!this.__Murl) {
            return this.__M_url();
        }
        try {
            this.__IM.onEntry((Object)this, "url", new Object[0]);
            string = this.__M_url();
            this.__IM.onExit((Object)this, "url", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "url", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_url() {
        return "/monitor/osgi/service";
    }

    @Override
    public String category() {
        String string;
        if (!this.__Mcategory) {
            return this.__M_category();
        }
        try {
            this.__IM.onEntry((Object)this, "category", new Object[0]);
            string = this.__M_category();
            this.__IM.onExit((Object)this, "category", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "category", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_category() {
        return "osgi";
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("context")) {
                this.__Fcontext = true;
            }
            if (set.contains("counter")) {
                this.__Fcounter = true;
            }
            if (set.contains("services")) {
                this.__Fservices = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("ServiceEventCounter___start")) {
                this.__MServiceEventCounter___start = true;
            }
            if (set.contains("ServiceEventCounter___reset")) {
                this.__MServiceEventCounter___reset = true;
            }
            if (set.contains("ServiceEventCounter___stop")) {
                this.__MServiceEventCounter___stop = true;
            }
            if (set.contains("ServiceEventCounter___get")) {
                this.__MServiceEventCounter___get = true;
            }
            if (set.contains("ServiceEventCounter___serviceChanged$org_osgi_framework_ServiceEvent")) {
                this.__MServiceEventCounter___serviceChanged$org_osgi_framework_ServiceEvent = true;
            }
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("svc")) {
                this.__Msvc = true;
            }
            if (set.contains("getProviderBundleCount$java_util_List")) {
                this.__MgetProviderBundleCount$java_util_List = true;
            }
            if (set.contains("getProviderCount$java_util_List")) {
                this.__MgetProviderCount$java_util_List = true;
            }
            if (set.contains("services")) {
                this.__Mservices = true;
            }
            if (set.contains("label")) {
                this.__Mlabel = true;
            }
            if (set.contains("url")) {
                this.__Murl = true;
            }
            if (set.contains("category")) {
                this.__Mcategory = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }

    private class ServiceEventCounter
    implements ServiceListener {
        int counter = 0;

        private ServiceEventCounter() {
        }

        public void start() {
            if (!ServiceMonitorExtension.this.__MServiceEventCounter___start) {
                this.__M_start();
                return;
            }
            try {
                ServiceMonitorExtension.this.__IM.onEntry((Object)this, "ServiceEventCounter___start", new Object[0]);
                this.__M_start();
                ServiceMonitorExtension.this.__IM.onExit((Object)this, "ServiceEventCounter___start", null);
            }
            catch (Throwable throwable) {
                ServiceMonitorExtension.this.__IM.onError((Object)this, "ServiceEventCounter___start", throwable);
                throw throwable;
            }
        }

        private void __M_start() {
            ServiceMonitorExtension.this.__getcontext().addServiceListener((ServiceListener)this);
        }

        public void reset() {
            if (!ServiceMonitorExtension.this.__MServiceEventCounter___reset) {
                this.__M_reset();
                return;
            }
            try {
                ServiceMonitorExtension.this.__IM.onEntry((Object)this, "ServiceEventCounter___reset", new Object[0]);
                this.__M_reset();
                ServiceMonitorExtension.this.__IM.onExit((Object)this, "ServiceEventCounter___reset", null);
            }
            catch (Throwable throwable) {
                ServiceMonitorExtension.this.__IM.onError((Object)this, "ServiceEventCounter___reset", throwable);
                throw throwable;
            }
        }

        private void __M_reset() {
            this.counter = 0;
        }

        public void stop() {
            if (!ServiceMonitorExtension.this.__MServiceEventCounter___stop) {
                this.__M_stop();
                return;
            }
            try {
                ServiceMonitorExtension.this.__IM.onEntry((Object)this, "ServiceEventCounter___stop", new Object[0]);
                this.__M_stop();
                ServiceMonitorExtension.this.__IM.onExit((Object)this, "ServiceEventCounter___stop", null);
            }
            catch (Throwable throwable) {
                ServiceMonitorExtension.this.__IM.onError((Object)this, "ServiceEventCounter___stop", throwable);
                throw throwable;
            }
        }

        private void __M_stop() {
            ServiceMonitorExtension.this.__getcontext().removeServiceListener((ServiceListener)this);
        }

        public int get() {
            int n;
            if (!ServiceMonitorExtension.this.__MServiceEventCounter___get) {
                return this.__M_get();
            }
            try {
                ServiceMonitorExtension.this.__IM.onEntry((Object)this, "ServiceEventCounter___get", new Object[0]);
                n = this.__M_get();
                ServiceMonitorExtension.this.__IM.onExit((Object)this, "ServiceEventCounter___get", (Object)new Integer(n));
            }
            catch (Throwable throwable) {
                ServiceMonitorExtension.this.__IM.onError((Object)this, "ServiceEventCounter___get", throwable);
                throw throwable;
            }
            return n;
        }

        private int __M_get() {
            return this.counter;
        }

        public void serviceChanged(ServiceEvent serviceEvent) {
            if (!ServiceMonitorExtension.this.__MServiceEventCounter___serviceChanged$org_osgi_framework_ServiceEvent) {
                this.__M_serviceChanged(serviceEvent);
                return;
            }
            try {
                ServiceMonitorExtension.this.__IM.onEntry((Object)this, "ServiceEventCounter___serviceChanged$org_osgi_framework_ServiceEvent", new Object[]{serviceEvent});
                this.__M_serviceChanged(serviceEvent);
                ServiceMonitorExtension.this.__IM.onExit((Object)this, "ServiceEventCounter___serviceChanged$org_osgi_framework_ServiceEvent", null);
            }
            catch (Throwable throwable) {
                ServiceMonitorExtension.this.__IM.onError((Object)this, "ServiceEventCounter___serviceChanged$org_osgi_framework_ServiceEvent", throwable);
                throw throwable;
            }
        }

        private void __M_serviceChanged(ServiceEvent serviceEvent) {
            ++this.counter;
        }
    }
}

