/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.monitor.extensions.terminal;

import java.io.PrintStream;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.wisdom.api.http.websockets.Publisher;
import org.wisdom.monitor.extensions.terminal.CommandResult;
import org.wisdom.monitor.extensions.terminal.OutputType;
import org.wisdom.monitor.extensions.terminal.WisitOutputStream;

public class WisitSession {
    private final CommandSession shellSession;

    public WisitSession(CommandProcessor processor, Publisher publisher, String topic) {
        WisitOutputStream resultStream = new WisitOutputStream(publisher, topic);
        WisitOutputStream errorStream = new WisitOutputStream(publisher, topic, OutputType.ERR);
        this.shellSession = processor.createSession(null, new PrintStream(resultStream, true), new PrintStream(errorStream, true));
    }

    public void close() {
        this.shellSession.close();
    }

    public CommandResult exec(String commandLine) {
        CommandResult result = new CommandResult(OutputType.RESULT);
        try {
            Object raw = this.shellSession.execute((CharSequence)commandLine);
            if (raw != null) {
                result.setContent(this.format(raw));
            }
        }
        catch (Exception e) {
            result.setType(OutputType.ERR);
            result.setContent(e.getMessage());
        }
        return result;
    }

    private String format(Object o) {
        return this.shellSession.format(o, 0).toString();
    }
}

