/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.monitor.extensions.terminal;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.Validate;
import org.apache.felix.service.command.CommandProcessor;
import org.ow2.shelbie.core.registry.CommandRegistry;
import org.ow2.shelbie.core.registry.info.CommandInfo;
import org.wisdom.api.DefaultController;
import org.wisdom.api.annotations.Body;
import org.wisdom.api.annotations.Controller;
import org.wisdom.api.annotations.Parameter;
import org.wisdom.api.annotations.Path;
import org.wisdom.api.annotations.Route;
import org.wisdom.api.annotations.View;
import org.wisdom.api.http.HttpMethod;
import org.wisdom.api.http.Result;
import org.wisdom.api.http.websockets.Publisher;
import org.wisdom.api.security.Authenticated;
import org.wisdom.api.templates.Template;
import org.wisdom.monitor.extensions.terminal.CommandResult;
import org.wisdom.monitor.extensions.terminal.WisitSession;
import org.wisdom.monitor.service.MonitorExtension;

@Path(value="/monitor/terminal")
@Authenticated(value="Monitor-Authenticator")
@Controller
public class WisitShellController
extends DefaultController
implements MonitorExtension,
Pojo {
    InstanceManager __IM;
    private boolean __FshellSession;
    private WisitSession shellSession;
    private boolean __FcommandRegistry;
    @Requires
    private CommandRegistry commandRegistry;
    private boolean __Fprocessor;
    @Requires
    private CommandProcessor processor;
    private boolean __Fpublisher;
    @Requires
    private Publisher publisher;
    private boolean __Fterminal;
    @View(value="monitor/terminal")
    Template terminal;
    boolean __Mstart;
    boolean __Mstop;
    boolean __Mterminal;
    boolean __Mping;
    boolean __Mcommands;
    boolean __Mcommand$java_lang_String$java_lang_String;
    boolean __MgetCommands;
    boolean __Mlabel;
    boolean __Murl;
    boolean __Mcategory;

    WisitSession __getshellSession() {
        if (!this.__FshellSession) {
            return this.shellSession;
        }
        return (WisitSession)this.__IM.onGet((Object)this, "shellSession");
    }

    void __setshellSession(WisitSession wisitSession) {
        if (!this.__FshellSession) {
            this.shellSession = wisitSession;
            return;
        }
        this.__IM.onSet((Object)this, "shellSession", (Object)wisitSession);
    }

    CommandRegistry __getcommandRegistry() {
        if (!this.__FcommandRegistry) {
            return this.commandRegistry;
        }
        return (CommandRegistry)this.__IM.onGet((Object)this, "commandRegistry");
    }

    void __setcommandRegistry(CommandRegistry commandRegistry) {
        if (!this.__FcommandRegistry) {
            this.commandRegistry = commandRegistry;
            return;
        }
        this.__IM.onSet((Object)this, "commandRegistry", (Object)commandRegistry);
    }

    CommandProcessor __getprocessor() {
        if (!this.__Fprocessor) {
            return this.processor;
        }
        return (CommandProcessor)this.__IM.onGet((Object)this, "processor");
    }

    void __setprocessor(CommandProcessor commandProcessor) {
        if (!this.__Fprocessor) {
            this.processor = commandProcessor;
            return;
        }
        this.__IM.onSet((Object)this, "processor", (Object)commandProcessor);
    }

    Publisher __getpublisher() {
        if (!this.__Fpublisher) {
            return this.publisher;
        }
        return (Publisher)this.__IM.onGet((Object)this, "publisher");
    }

    void __setpublisher(Publisher publisher) {
        if (!this.__Fpublisher) {
            this.publisher = publisher;
            return;
        }
        this.__IM.onSet((Object)this, "publisher", (Object)publisher);
    }

    Template __getterminal() {
        if (!this.__Fterminal) {
            return this.terminal;
        }
        return (Template)this.__IM.onGet((Object)this, "terminal");
    }

    void __setterminal(Template template) {
        if (!this.__Fterminal) {
            this.terminal = template;
            return;
        }
        this.__IM.onSet((Object)this, "terminal", (Object)template);
    }

    public WisitShellController() {
        this(null);
    }

    private WisitShellController(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public void start() {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __M_start() {
        this.__setshellSession(new WisitSession(this.__getprocessor(), this.__getpublisher(), "/monitor/terminal/stream"));
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __M_stop() {
        this.__getshellSession().close();
    }

    @Route(uri="", method=HttpMethod.GET)
    public Result terminal() {
        Result result;
        if (!this.__Mterminal) {
            return this.__M_terminal();
        }
        try {
            this.__IM.onEntry((Object)this, "terminal", new Object[0]);
            result = this.__M_terminal();
            this.__IM.onExit((Object)this, "terminal", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "terminal", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_terminal() {
        return WisitShellController.ok((Object)this.render(this.__getterminal()));
    }

    @Route(uri="", method=HttpMethod.OPTIONS)
    public Result ping() {
        Result result;
        if (!this.__Mping) {
            return this.__M_ping();
        }
        try {
            this.__IM.onEntry((Object)this, "ping", new Object[0]);
            result = this.__M_ping();
            this.__IM.onExit((Object)this, "ping", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "ping", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_ping() {
        return WisitShellController.ok();
    }

    @Route(uri="/command", method=HttpMethod.GET)
    public Result commands() {
        Result result;
        if (!this.__Mcommands) {
            return this.__M_commands();
        }
        try {
            this.__IM.onEntry((Object)this, "commands", new Object[0]);
            result = this.__M_commands();
            this.__IM.onExit((Object)this, "commands", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "commands", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_commands() {
        return WisitShellController.ok(this.getCommands()).json();
    }

    @Route(uri="/command/{name}", method=HttpMethod.POST)
    public Result command(@Parameter(value="name") String name, @Body String args) {
        Result result;
        if (!this.__Mcommand$java_lang_String$java_lang_String) {
            return this.__M_command(name, args);
        }
        try {
            this.__IM.onEntry((Object)this, "command$java_lang_String$java_lang_String", new Object[]{name, args});
            result = this.__M_command(name, args);
            this.__IM.onExit((Object)this, "command$java_lang_String$java_lang_String", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "command$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_command(String name, String args) {
        CommandResult result = this.__getshellSession().exec(name + " " + args);
        if (result.isEmpty()) {
            return WisitShellController.ok();
        }
        return WisitShellController.ok((String)result.toString());
    }

    public Collection<String> getCommands() {
        Collection<String> collection;
        if (!this.__MgetCommands) {
            return this.__M_getCommands();
        }
        try {
            this.__IM.onEntry((Object)this, "getCommands", new Object[0]);
            collection = this.__M_getCommands();
            this.__IM.onExit((Object)this, "getCommands", collection);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getCommands", throwable);
            throw throwable;
        }
        return collection;
    }

    private Collection<String> __M_getCommands() {
        HashSet<String> commands = new HashSet<String>();
        Collection commandInfos = this.__getcommandRegistry().getAllCommands();
        for (CommandInfo info : commandInfos) {
            commands.add(info.getName());
        }
        return commands;
    }

    @Override
    public String label() {
        String string;
        if (!this.__Mlabel) {
            return this.__M_label();
        }
        try {
            this.__IM.onEntry((Object)this, "label", new Object[0]);
            string = this.__M_label();
            this.__IM.onExit((Object)this, "label", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "label", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_label() {
        return "Shell";
    }

    @Override
    public String url() {
        String string;
        if (!this.__Murl) {
            return this.__M_url();
        }
        try {
            this.__IM.onEntry((Object)this, "url", new Object[0]);
            string = this.__M_url();
            this.__IM.onExit((Object)this, "url", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "url", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_url() {
        return "/monitor/terminal";
    }

    @Override
    public String category() {
        String string;
        if (!this.__Mcategory) {
            return this.__M_category();
        }
        try {
            this.__IM.onEntry((Object)this, "category", new Object[0]);
            string = this.__M_category();
            this.__IM.onExit((Object)this, "category", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "category", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_category() {
        return "osgi";
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("commandRegistry")) {
                this.__FcommandRegistry = true;
            }
            if (set.contains("processor")) {
                this.__Fprocessor = true;
            }
            if (set.contains("publisher")) {
                this.__Fpublisher = true;
            }
            if (set.contains("shellSession")) {
                this.__FshellSession = true;
            }
            if (set.contains("terminal")) {
                this.__Fterminal = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("terminal")) {
                this.__Mterminal = true;
            }
            if (set.contains("ping")) {
                this.__Mping = true;
            }
            if (set.contains("commands")) {
                this.__Mcommands = true;
            }
            if (set.contains("command$java_lang_String$java_lang_String")) {
                this.__Mcommand$java_lang_String$java_lang_String = true;
            }
            if (set.contains("getCommands")) {
                this.__MgetCommands = true;
            }
            if (set.contains("label")) {
                this.__Mlabel = true;
            }
            if (set.contains("url")) {
                this.__Murl = true;
            }
            if (set.contains("category")) {
                this.__Mcategory = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

