/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.monitor.extensions.wisdom;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.architecture.Architecture;
import org.apache.felix.ipojo.architecture.InstanceDescription;
import org.apache.felix.ipojo.handlers.providedservice.ProvidedServiceDescription;
import org.apache.felix.ipojo.handlers.providedservice.ProvidedServiceHandlerDescription;
import org.wisdom.api.Controller;
import org.wisdom.api.DefaultController;
import org.wisdom.api.annotations.Route;
import org.wisdom.api.annotations.View;
import org.wisdom.api.content.Json;
import org.wisdom.api.http.HttpMethod;
import org.wisdom.api.http.Result;
import org.wisdom.api.router.Router;
import org.wisdom.api.security.Authenticated;
import org.wisdom.api.templates.Template;
import org.wisdom.monitor.extensions.wisdom.ControllerModel;
import org.wisdom.monitor.service.MonitorExtension;

@Authenticated(value="Monitor-Authenticator")
@org.wisdom.api.annotations.Controller
public class ControllerExtension
extends DefaultController
implements MonitorExtension,
Pojo {
    InstanceManager __IM;
    private boolean __Ftemplate;
    @View(value="monitor/controllers")
    Template template;
    private boolean __Fcontrollers;
    @Requires
    Controller[] controllers;
    private boolean __Frouter;
    @Requires
    Router router;
    private boolean __Fjson;
    @Requires
    Json json;
    private boolean __Farchitectures;
    @Requires
    Architecture[] architectures;
    boolean __Mindex;
    boolean __MgetControllers;
    boolean __MgetInvalidControllers;
    boolean __Mlabel;
    boolean __Murl;
    boolean __Mcategory;

    Template __gettemplate() {
        if (!this.__Ftemplate) {
            return this.template;
        }
        return (Template)this.__IM.onGet((Object)this, "template");
    }

    void __settemplate(Template template) {
        if (!this.__Ftemplate) {
            this.template = template;
            return;
        }
        this.__IM.onSet((Object)this, "template", (Object)template);
    }

    Controller[] __getcontrollers() {
        if (!this.__Fcontrollers) {
            return this.controllers;
        }
        return (Controller[])this.__IM.onGet((Object)this, "controllers");
    }

    void __setcontrollers(Controller[] controllerArray) {
        if (!this.__Fcontrollers) {
            this.controllers = controllerArray;
            return;
        }
        this.__IM.onSet((Object)this, "controllers", (Object)controllerArray);
    }

    Router __getrouter() {
        if (!this.__Frouter) {
            return this.router;
        }
        return (Router)this.__IM.onGet((Object)this, "router");
    }

    void __setrouter(Router router) {
        if (!this.__Frouter) {
            this.router = router;
            return;
        }
        this.__IM.onSet((Object)this, "router", (Object)router);
    }

    Json __getjson() {
        if (!this.__Fjson) {
            return this.json;
        }
        return (Json)this.__IM.onGet((Object)this, "json");
    }

    void __setjson(Json json) {
        if (!this.__Fjson) {
            this.json = json;
            return;
        }
        this.__IM.onSet((Object)this, "json", (Object)json);
    }

    Architecture[] __getarchitectures() {
        if (!this.__Farchitectures) {
            return this.architectures;
        }
        return (Architecture[])this.__IM.onGet((Object)this, "architectures");
    }

    void __setarchitectures(Architecture[] architectureArray) {
        if (!this.__Farchitectures) {
            this.architectures = architectureArray;
            return;
        }
        this.__IM.onSet((Object)this, "architectures", (Object)architectureArray);
    }

    public ControllerExtension() {
        this(null);
    }

    private ControllerExtension(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    @Route(uri="/monitor/controllers", method=HttpMethod.GET)
    public Result index() {
        Result result;
        if (!this.__Mindex) {
            return this.__M_index();
        }
        try {
            this.__IM.onEntry((Object)this, "index", new Object[0]);
            result = this.__M_index();
            this.__IM.onExit((Object)this, "index", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "index", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_index() {
        return ControllerExtension.ok((Object)this.render(this.__gettemplate()));
    }

    @Route(uri="/monitor/controllers/controllers", method=HttpMethod.GET)
    public Result getControllers() {
        Result result;
        if (!this.__MgetControllers) {
            return this.__M_getControllers();
        }
        try {
            this.__IM.onEntry((Object)this, "getControllers", new Object[0]);
            result = this.__M_getControllers();
            this.__IM.onExit((Object)this, "getControllers", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getControllers", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_getControllers() {
        ObjectNode node = this.__getjson().newObject();
        ArrayNode array = this.__getjson().newArray();
        for (Controller controller : this.__getcontrollers()) {
            array.add(ControllerModel.from(controller, this.__getrouter(), this.__getjson()));
        }
        for (InstanceDescription description : this.getInvalidControllers()) {
            array.add(ControllerModel.from(description, this.__getjson()));
        }
        node.put("controllers", (JsonNode)array);
        node.put("invalid", this.getInvalidControllers().size());
        return ControllerExtension.ok((JsonNode)node);
    }

    private List<InstanceDescription> getInvalidControllers() {
        List<InstanceDescription> list;
        if (!this.__MgetInvalidControllers) {
            return this.__M_getInvalidControllers();
        }
        try {
            this.__IM.onEntry((Object)this, "getInvalidControllers", new Object[0]);
            list = this.__M_getInvalidControllers();
            this.__IM.onExit((Object)this, "getInvalidControllers", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getInvalidControllers", throwable);
            throw throwable;
        }
        return list;
    }

    private List<InstanceDescription> __M_getInvalidControllers() {
        ArrayList<InstanceDescription> invalid = new ArrayList<InstanceDescription>();
        for (Architecture architecture : this.__getarchitectures()) {
            ProvidedServiceHandlerDescription hd;
            InstanceDescription description = architecture.getInstanceDescription();
            if (description.getState() != 1 || (hd = (ProvidedServiceHandlerDescription)description.getHandlerDescription("org.apache.felix.ipojo:provides")) == null) continue;
            for (ProvidedServiceDescription psd : hd.getProvidedServices()) {
                if (!Arrays.asList(psd.getServiceSpecifications()).contains(Controller.class.getName())) continue;
                invalid.add(description);
            }
        }
        return invalid;
    }

    @Override
    public String label() {
        String string;
        if (!this.__Mlabel) {
            return this.__M_label();
        }
        try {
            this.__IM.onEntry((Object)this, "label", new Object[0]);
            string = this.__M_label();
            this.__IM.onExit((Object)this, "label", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "label", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_label() {
        return "Controllers";
    }

    @Override
    public String url() {
        String string;
        if (!this.__Murl) {
            return this.__M_url();
        }
        try {
            this.__IM.onEntry((Object)this, "url", new Object[0]);
            string = this.__M_url();
            this.__IM.onExit((Object)this, "url", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "url", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_url() {
        return "/monitor/controllers";
    }

    @Override
    public String category() {
        String string;
        if (!this.__Mcategory) {
            return this.__M_category();
        }
        try {
            this.__IM.onEntry((Object)this, "category", new Object[0]);
            string = this.__M_category();
            this.__IM.onExit((Object)this, "category", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "category", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_category() {
        return "Wisdom";
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("architectures")) {
                this.__Farchitectures = true;
            }
            if (set.contains("controllers")) {
                this.__Fcontrollers = true;
            }
            if (set.contains("json")) {
                this.__Fjson = true;
            }
            if (set.contains("router")) {
                this.__Frouter = true;
            }
            if (set.contains("template")) {
                this.__Ftemplate = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("index")) {
                this.__Mindex = true;
            }
            if (set.contains("getControllers")) {
                this.__MgetControllers = true;
            }
            if (set.contains("getInvalidControllers")) {
                this.__MgetInvalidControllers = true;
            }
            if (set.contains("label")) {
                this.__Mlabel = true;
            }
            if (set.contains("url")) {
                this.__Murl = true;
            }
            if (set.contains("category")) {
                this.__Mcategory = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

