/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.monitor.extensions.wisdom;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Requires;
import org.wisdom.api.DefaultController;
import org.wisdom.api.annotations.Controller;
import org.wisdom.api.annotations.View;
import org.wisdom.api.content.Json;
import org.wisdom.api.http.HttpMethod;
import org.wisdom.api.http.Result;
import org.wisdom.api.router.Route;
import org.wisdom.api.router.Router;
import org.wisdom.api.security.Authenticated;
import org.wisdom.api.templates.Template;
import org.wisdom.monitor.extensions.wisdom.RouteModel;
import org.wisdom.monitor.service.MonitorExtension;

@Authenticated(value="Monitor-Authenticator")
@Controller
public class RouterExtension
extends DefaultController
implements MonitorExtension,
Pojo {
    InstanceManager __IM;
    private boolean __Ftemplate;
    @View(value="monitor/routes")
    Template template;
    private boolean __Frouter;
    @Requires
    Router router;
    private boolean __Fjson;
    @Requires
    Json json;
    boolean __Mindex;
    boolean __MgetRoutes;
    boolean __Mlabel;
    boolean __Murl;
    boolean __Mcategory;

    Template __gettemplate() {
        if (!this.__Ftemplate) {
            return this.template;
        }
        return (Template)this.__IM.onGet((Object)this, "template");
    }

    void __settemplate(Template template) {
        if (!this.__Ftemplate) {
            this.template = template;
            return;
        }
        this.__IM.onSet((Object)this, "template", (Object)template);
    }

    Router __getrouter() {
        if (!this.__Frouter) {
            return this.router;
        }
        return (Router)this.__IM.onGet((Object)this, "router");
    }

    void __setrouter(Router router) {
        if (!this.__Frouter) {
            this.router = router;
            return;
        }
        this.__IM.onSet((Object)this, "router", (Object)router);
    }

    Json __getjson() {
        if (!this.__Fjson) {
            return this.json;
        }
        return (Json)this.__IM.onGet((Object)this, "json");
    }

    void __setjson(Json json) {
        if (!this.__Fjson) {
            this.json = json;
            return;
        }
        this.__IM.onSet((Object)this, "json", (Object)json);
    }

    public RouterExtension() {
        this(null);
    }

    private RouterExtension(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    @org.wisdom.api.annotations.Route(uri="/monitor/routes", method=HttpMethod.GET)
    public Result index() {
        Result result;
        if (!this.__Mindex) {
            return this.__M_index();
        }
        try {
            this.__IM.onEntry((Object)this, "index", new Object[0]);
            result = this.__M_index();
            this.__IM.onExit((Object)this, "index", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "index", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_index() {
        return RouterExtension.ok((Object)this.render(this.__gettemplate()));
    }

    @org.wisdom.api.annotations.Route(uri="/monitor/routes/routes", method=HttpMethod.GET)
    public Result getRoutes() {
        Result result;
        if (!this.__MgetRoutes) {
            return this.__M_getRoutes();
        }
        try {
            this.__IM.onEntry((Object)this, "getRoutes", new Object[0]);
            result = this.__M_getRoutes();
            this.__IM.onExit((Object)this, "getRoutes", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRoutes", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_getRoutes() {
        ArrayNode array = this.__getjson().newArray();
        for (Route route : this.__getrouter().getRoutes()) {
            array.add((JsonNode)RouteModel.from(route, this.__getjson()));
        }
        return RouterExtension.ok((JsonNode)array);
    }

    @Override
    public String label() {
        String string;
        if (!this.__Mlabel) {
            return this.__M_label();
        }
        try {
            this.__IM.onEntry((Object)this, "label", new Object[0]);
            string = this.__M_label();
            this.__IM.onExit((Object)this, "label", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "label", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_label() {
        return "Routes";
    }

    @Override
    public String url() {
        String string;
        if (!this.__Murl) {
            return this.__M_url();
        }
        try {
            this.__IM.onEntry((Object)this, "url", new Object[0]);
            string = this.__M_url();
            this.__IM.onExit((Object)this, "url", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "url", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_url() {
        return "/monitor/routes";
    }

    @Override
    public String category() {
        String string;
        if (!this.__Mcategory) {
            return this.__M_category();
        }
        try {
            this.__IM.onEntry((Object)this, "category", new Object[0]);
            string = this.__M_category();
            this.__IM.onExit((Object)this, "category", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "category", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_category() {
        return "Wisdom";
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("json")) {
                this.__Fjson = true;
            }
            if (set.contains("router")) {
                this.__Frouter = true;
            }
            if (set.contains("template")) {
                this.__Ftemplate = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("index")) {
                this.__Mindex = true;
            }
            if (set.contains("getRoutes")) {
                this.__MgetRoutes = true;
            }
            if (set.contains("label")) {
                this.__Mlabel = true;
            }
            if (set.contains("url")) {
                this.__Murl = true;
            }
            if (set.contains("category")) {
                this.__Mcategory = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

