/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.content.converters;

import org.wisdom.api.content.ParameterConverter;

public final class CharacterConverter
implements ParameterConverter<Character> {
    public static final CharacterConverter INSTANCE = new CharacterConverter();

    private CharacterConverter() {
    }

    public Character fromString(String input) throws IllegalArgumentException {
        if (input == null) {
            throw new NullPointerException("input must not be null");
        }
        if (input.length() != 1) {
            throw new IllegalArgumentException("The input string \"" + input + "\" cannot be converted to a " + "character. The input's length must be 1");
        }
        return Character.valueOf(input.toCharArray()[0]);
    }

    public Class<Character> getType() {
        return Character.class;
    }
}

